<?php
//addons/geographic_navigation/tags.php
/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21275              $ ##
## File last change date:       ##
##  $Date:: 2011-04-22 17:08:#$ ##
##                              ##
##################################

//Extends info class, double check to make sure it is included already
require_once ADDON_DIR . 'geographic_navigation/info.php';

class addon_geographic_navigation_tags extends addon_geographic_navigation_info
{
	private function _checkDisabled ()
	{
		return !(geoPC::is_print() && DataAccess::getInstance()->get_site_setting('disableAllBrowsing'));
	}
	
	public function breadcrumb ()
	{
		if (!$this->_checkDisabled()) {
			//browsing disabled, no breadcrumb to display
			return '';
		}
		$reg = geoAddon::getRegistry('geographic_navigation');
		$view = geoView::getInstance();
		
		/**
		 * 
		 * Enter description here ...
		 * @var addon_geographic_navigation_util
		 */
		$util = geoAddon::getUtil('geographic_navigation');
		
		$view->setAddonTpl($this->auth_tag,$this->name,'breadcrumb','breadcrumb.tpl')
			->addCssFile(geoTemplate::getURL('css','addon/geographic_navigation/navigation.css'));
		
		$vars = array();
		
		$regionName = (isset($_COOKIE['region']))? trim($_COOKIE['region']) : 0;
		
		//TODO: Make better way to get tree of regions
		$vars['breadcrumb'] = $util->getBreadcrumbFor($regionName);
		$vars['base_url'] = $util->getBaseUrl();
		$vars ['msgs'] = geoAddon::getText($this->auth_tag, $this->name);
		$view->setAddonVar($this->auth_tag,$this->name,'breadcrumb',$vars);
	}
	
	
	
	public function navigation ()
	{
		if (!$this->_checkDisabled()) {
			//browsing disabled, no navigation to display
			return '';
		}
		$reg = geoAddon::getRegistry('geographic_navigation');
		$view = geoView::getInstance();
		
		/**
		 * 
		 * Enter description here ...
		 * @var addon_geographic_navigation_util
		 */
		$util = geoAddon::getUtil('geographic_navigation');
		
		$view->setAddonTpl($this->auth_tag,$this->name,'navigation','navigation/standard.tpl')
			->addCssFile(geoTemplate::getURL('css','addon/geographic_navigation/navigation.css'));
		
		$vars = array();
		
		//get those things sorted!
		$vars['regions'] = $this->_getRegionData();
		
		$regionName = (isset($_COOKIE['region']))? trim($_COOKIE['region']) : 0;
		
		//TODO: Make better way to get tree of regions
		if ($reg->tree) $vars['breadcrumb'] = $util->getBreadcrumbFor($regionName);
		$vars['countFormat'] = $reg->countFormat;
		$vars['domain'] = $util->getDomain(true).'/'.DataAccess::getInstance()->get_site_setting('classifieds_file_name').rtrim($this->_getBaseUrl(true),'?&');
		$vars['base_url'] = $this->_getBaseUrl();
		
		
		//die ("regions: <pre>".print_r($vars['regions'],1));
		
		$vars['columns'] = $columns = $reg->get("columns");
		$vars['subdomains'] = ($reg->subdomains == 'on');
		$columnCount = $reg->get('columns',1);
		$vars['col_width'] = floor(100/$columnCount).'%';
		
		//die ("region: $regionId state: $stateId country: $countryId vars: <pre>".print_r($vars,1));
		$vars['treeType'] = $reg->tree;
		
		$vars ['msgs'] = geoAddon::getText($this->auth_tag, $this->name);
		$view->setAddonVar($this->auth_tag,$this->name,'navigation',$vars);
		//return $out;
	}
	
	public function listing_regions ()
	{
		if (!$this->_checkDisabled()) {
			//browsing disabled, shouldn't be able to show this
			return '';
		}
		//figure out the listing ID
		$view = geoView::getInstance();
		
		if (!$view->classified_id) {
			//id NOT set
			return '';
		}
		$listingId = (int)$view->classified_id;
		
		$util = geoAddon::getUtil($this->name);
		
		geoView::getInstance()->setAddonTpl($this->auth_tag,$this->name,'listing_regions','listing_regions.tpl')
			->setAddonVar($this->auth_tag,$this->name,'listing_regions','regions', $util->getRegionsForDisplay($listingId));
		
		return '';
	}
	
	private function _getBaseUrl ($queryOnly = false)
	{
		$db = DataAccess::getInstance();
		$skip_list = array('region','subregion');
		$parts = array();
		foreach ($_GET as $key => $value) {
			if (!in_array($key,$skip_list)) {
				if (is_array($value)) {
					foreach ($value as $sub_i => $sub_v) {
						$parts[] = "{$key}[{$sub_i}]=$sub_v";
					}
				} else {
					$parts[] = "$key=$value";
				}
			}
		}
		$base = $db->get_site_setting('classifieds_url');
		if ($queryOnly) {
			$base = '';
		}
		if (count($parts)) {
			return $base.'?'.implode("&",$parts)."&";
		}
		return $base.'?';
	}
	
	private function _getRegionData ($skipOnlyOneCheck=false)
	{
		$regionId = (isset($_COOKIE['region']))? trim($_COOKIE['region']) : 0;
		
		$reg = geoAddon::getRegistry($this->name);
		$util = geoAddon::getUtil($this->name);
		
		$all = $util->getRegionsFor($regionId);
		$all = (is_array($all))? $all : array();
		if (!$regionId && !$skipOnlyOneCheck && count($all) == 1) {
			//only one at this level
			$_COOKIE['region'] = $all[0]['id'];
			return $this->_getRegionData(true);
		}
		
		$regionCount = 0;
		$regions = array();
		foreach ($all as $row) {
			if ($reg->showSubs) {
				//get sub-regions
				$row['sub_regions'] = $util->getRegionsFor($row['id']);
				$regionCount += count($row['sub_regions']);
			}
			if ($reg->countFormat) {
				$row['listing_counts'] = $util->getListingCounts($row['id']);
			}
			
			$regions[] = $row;
			$regionCount++;
		}
		//now need to sort them in different loop
		$sortedRegions = array();
		$columnCount = $reg->get('columns',1);
		$maxColumnCount = ceil($regionCount/$columnCount);
		$currentColumn = $currentCount = 0;
		foreach ($regions as $i => $row) {
			$sortedRegions [$currentColumn][] = $row;
			
			if ($reg->alpha_across_columns) {
				$currentColumn++;
				//reset back to 0 if needed.
				if ($currentColumn >= $columnCount) $currentColumn = 0;
			} else {
				$currentCount ++;
				if (isset($row['sub_regions'])) {
					$currentCount += count($row['sub_regions']);
				}
				
				if ($currentCount >= $maxColumnCount && $currentColumn < $columnCount) {
					//make column count "start" at where it would start if the
					//previous column was allowed to newline on sub cats
					
					$currentColumn++;
					$currentCount = $currentCount%$maxColumnCount;
				}
			}
		}
		
		return $sortedRegions;
	}
}