<?php
/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21275              $ ##
## File last change date:       ##
##  $Date:: 2011-04-22 17:08:#$ ##
##                              ##
##################################

class addon_geographic_navigation_admin extends addon_geographic_navigation_info {
	var $body;
	private $self_path;
	public $url;
	
	/**
	 * Message displayed at the top of every regions filter addon page in the admin, to avoid support
	 * issues because people have the wrong idea about what it does.
	 * @return string
	 */
	public function disclaimer ()
	{
		return "<div class='page_note'>Note: Countries and State/Provinces are <strong>part of the main software</strong>, and are used by 
		payment gateways to process payments, and are also used to calculate taxes.  The unlimited levels of regions and
		sub-regions added by this addon, however, are not restricted by having to conform to country or state/province level.  See the user
		manual for a more thorough explanation.</div>";
	}
	
	public function init_pages ()
	{
		menu_page::addonAddPage('addon_geographic_navigation_settings','','Settings','geographic_navigation',$this->icon_image);
		menu_page::addonAddPage('geographic_addon_regions','','Regions','geographic_navigation',$this->icon_image);
		menu_page::addonAddPage('addon_geographic_navigation_subdomains','','Sub Domains','geographic_navigation',$this->icon_image);
		
		$this->self_path = "?page={$_GET['page']}&mc=addon_geographic_navigation_admin";
	}
	
	public function display_geographic_addon_regions ()
	{
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		$view = geoView::getInstance();
		
		//get all the main regions
		$region = geoRegion::getInstance();
		$reg = geoAddon::getRegistry($this->name);
		$util = geoAddon::getUtil($this->name);
		
		$all = $region->getRegionsList('',true);
		
		$regions = array();
		
		foreach($all as $id => $regionData) {
			$regions[] = array (
				'id' => $id,
				'name' => $regionData['name'],
				'subdomain' => $regionData['subdomain'],
				'level' => 'Country',
				'on_off' => true,
				'on_off_value' => (($regionData['addon_geographic_navigation_used'])? true: false),
				'childClass' => 'isCountry'
			);
		}
		
		//not attached regions
		$sql = "SELECT * FROM ".self::REGION_TABLE." WHERE `parent_region`=0 AND `parent_state`=0
			ORDER BY `display_order`";
		$all = $db->GetAll($sql);
		$uregions = array();
		foreach ($all as $regionData) {
			$uregions [] = array (
				'id' => $regionData['id'],
				'name' => geoString::fromDB($regionData['label']),
				'subdomain' => $regionData['subdomain'],
				'level' => 'Region Level 1',
				'childClass' => 'isRegion',
			);
		}
		$uregions[] = array (
			'id' => 'new',
			'parent_state' => 0,
			'parent_region' => 0,
			'childClass' => 'isRegion',
			'level' => 'Region Level 1'
		);
		$tpl_vars = array ();
		$tpl_vars['regions'] = $regions;
		$tpl_vars['uregions'] = $uregions;
		$tpl_vars['subdomains'] = $reg->subdomains;
		
		$tpl_vars['domain'] = $util->getDomain();
		
		$view->addJScript('../addons/geographic_navigation/admin.js')
			->addCssFile('../addons/geographic_navigation/admin.css')
			->setBodyTpl('admin/system_regions.tpl','geographic_navigation')
			->setBodyVar($tpl_vars);
	}
	
	public function display_addon_geographic_navigation_subdomains ()
	{
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		$reg = geoAddon::getRegistry($this->name);
		$util = geoAddon::getUtil($this->name);
		
		$tpl_vars = array();
		$tpl_vars['adminMessages'] = geoAdmin::m();
		
		$tpl_vars['subdomains'] = $reg->subdomains;
		$tpl_vars['domain'] = $util->getDomain();
		
		//get all sub-domains, if there aren't too many
		
		$count = (int)$db->GetOne("SELECT COUNT (*) FROM ".self::REGION_TABLE." WHERE `subdomain`!=''");
		$count += (int)$db->GetOne("SELECT COUNT (*) FROM ".geoTables::countries_table." WHERE `subdomain`!=''");
		$count += (int)$db->GetOne("SELECT COUNT (*) FROM ".geoTables::states_table." WHERE `subdomain`!=''");
		
		$tpl_vars['count'] = $count;
		
		if ($count > 500) {
			//oops there are too many!
			$tpl_vars['tooMany'] = 1;
		} else {
			$all = $db->GetAll("SELECT `subdomain` FROM ".self::REGION_TABLE."
				WHERE `subdomain`!=''");
			$all = array_merge($all, $db->GetAll("SELECT `subdomain` FROM ".geoTables::countries_table."
				WHERE `subdomain`!='' AND ".self::COLUMN_NAME."=1"));
			$all = array_merge($all, $db->GetAll("SELECT `subdomain` FROM ".geoTables::states_table."
				WHERE `subdomain`!='' AND ".self::COLUMN_NAME."=1"));
			$tpl_vars['subDomainList'] = $all;
		}
		
		geoView::getInstance()->setBodyVar($tpl_vars)
			->setBodyTpl('admin/subdomains.tpl',$this->name);
	}
	
	public function update_addon_geographic_navigation_subdomains ()
	{
		$validSettings = array ('configure','on');
		
		$subdomains = $_POST['subdomains'];
		//it's either configure, on, or false for off.
		$subdomains = (in_array($subdomains, $validSettings))? $subdomains : false;
		
		//save settings
		$reg = geoAddon::getRegistry($this->name);
		$reg->subdomains = $subdomains;
		$reg->save();
		
		if ($subdomains && isset($_POST['autoAdd']) && $_POST['autoAdd']=='add') {
			//auto-add sub-domain for every region found
			$db = DataAccess::getInstance();
			$util = geoAddon::getUtil($this->name);
			//auto-set for countries
			
			$skipped = $set = 0;
			$skipped_text = '';
			
			$countries = $db->GetAll("SELECT * FROM ".geoTables::countries_table." WHERE `subdomain`='' AND `addon_geographic_navigation_used`=1");
			
			foreach ($countries as $country) {
				$countryId = (int)$country['country_id'];
				$subdomain = $util->subdomainClean($country['abbreviation']);
				
				if (!$countryId || !$subdomain || $util->subdomainUsed($subdomain)) {
					//echo __line__." here. $countryId - $subdomain<br />";
					$skipped++;
					$skipped_text .= "Country: {$country['name']}($countryId) - Would-be Subdomain: $subdomain<br />";
					continue;
				}
				$db->Execute("UPDATE ".geoTables::countries_table." SET `subdomain`=? WHERE `country_id`=?",
					array ($subdomain, $countryId));
				$set++;
			}
			
			//auto-set for states
			$states = $db->GetAll("SELECT * FROM ".geoTables::states_table." WHERE `subdomain`='' AND `addon_geographic_navigation_used`=1");
			
			foreach ($states as $state) {
				$stateId = (int)$state['state_id'];
				$subdomain = $state['abbreviation'];
				
				//prepend with parent subdomain if there is one
				if ($state['parent_id']) {
					$country = $db->GetOne("SELECT `subdomain` FROM ".geoTables::countries_table." WHERE `country_id`=?", array((int)$state['parent_id']));
					if ($country) {
						$subdomain = "$subdomain.$country";
					}
				}
				
				$subdomain = $util->subdomainClean($subdomain);
				if (!$stateId || !$subdomain || $util->subdomainUsed($subdomain)) {
					//echo __line__." $stateId - $subdomain here.<br />";
					$skipped++;
					$skipped_text .= "State: {$state['name']}($stateId) - Would-be Subdomain: $subdomain<br />";
					continue;
				}
				$db->Execute("UPDATE ".geoTables::states_table." SET `subdomain`=? WHERE `state_id`=?",
					array ($subdomain, $stateId));
				$set++;
			}
			
			//auto-set for regions
			$regions = $db->GetAll("SELECT * FROM ".self::REGION_TABLE." WHERE `subdomain`='' ORDER BY `parent_region` ASC");
			
			foreach ($regions as $region) {
				$regionId = (int)$region['id'];
				$subdomain = geoString::fromDB($region['label']);
				
				//prepend with parent subdomain if there is one
				if ($region['parent_region']) {
					$sub = $db->GetOne("SELECT `subdomain` FROM ".self::REGION_TABLE." WHERE `id`=?", array((int)$region['parent_region']));
					if ($sub) {
						$subdomain = "$subdomain.$sub";
					}
				} else if ($region['parent_state']) {
					$sub = $db->GetOne("SELECT `subdomain` FROM ".geoTables::states_table." WHERE `state_id`=?", array((int)$region['parent_state']));
					if ($sub) {
						$subdomain = "$subdomain.$sub";
					}
				}
				
				$subdomain = $util->subdomainClean($subdomain);
				if (!$regionId || !$subdomain || $util->subdomainUsed($subdomain)) {
					//echo __line__." $regionId - $subdomain here.<br />";
					$skipped++;
					$skipped_text .= "Region: ".geoString::fromDB($region['label'])."($regionId) - Would-be Subdomain: $subdomain<br />";
					continue;
				}
				$db->Execute("UPDATE ".self::REGION_TABLE." SET `subdomain`=? WHERE `id`=?",
					array ($subdomain, $regionId));
				$set++;
			}
			$message = "Settings saved, and subdomains automatically set for $set locations.";
			if ($skipped) $message .= "($skipped possible duplicates skipped, see details listed above)";
			geoAdmin::m($message, geoAdmin::SUCCESS);
			if ($skipped_text) {
				geoAdmin::m("The following locations were skipped, most likely because of a duplicate sub-domain already in use:<br /><br />".$skipped_text, geoAdmin::NOTICE);
			}
		} else if ($subdomains && isset($_POST['autoAdd']) && $_POST['autoAdd']=='clear') {
			//going to clear all sub-domains
			$db = DataAccess::getInstance();
			
			$db->Execute("UPDATE ".geoTables::countries_table." SET `subdomain`=''");
			$db->Execute("UPDATE ".geoTables::states_table." SET `subdomain`=''");
			$db->Execute("UPDATE ".self::REGION_TABLE." SET `subdomain`=''");
			geoAdmin::m("Settings saved, and all subdomains for all locations have been cleared.", geoAdmin::SUCCESS);
		}
		
		
		return true;
	}
	
	public function display_addon_geographic_navigation_settings () 
	{
		$reg = geoAddon::getRegistry($this->name);
		
		$tpl_vars = array();
		$tpl_vars['adminMessages'] = geoAdmin::m();
		
		$tpl_vars['disclaimer'] = $this->disclaimer();
		$tpl_vars['columns'] = (int)$reg->get("columns");
		$tpl_vars['tree'] = $reg->tree;
		$tpl_vars['userUse'] = $reg->get('userUse');
		$tpl_vars['userRequire'] = $reg->get('userRequire');
		$tpl_vars['userEndRequire'] = $reg->get('userEndRequire');
		$tpl_vars['showInSearchBox'] = $reg->showInSearchBox;
		$tpl_vars['showInTitleListing'] = $reg->showInTitleListing;
		$tpl_vars['showInTitle'] = $reg->showInTitle;
		
		$tpl_vars['countFormat'] = $reg->countFormat;
		$tpl_vars['showSubs'] = $reg->showSubs;
		$tpl_vars['alpha_across_columns'] = $reg->alpha_across_columns;
		$tpl_vars['combineTree'] = $reg->combineTree;
		
		$tpl_vars['countOptions'] = array (0 => 'No Counts');
		
		if (geoPC::is_classifieds()) {
			$tpl_vars['countOptions']['c'] = 'Classified Count';
		}
		if (geoPC::is_auctions()) {
			$tpl_vars['countOptions']['a'] = 'Auction Count';
		}
		if (geoPC::is_class_auctions()) {
			$tpl_vars['countOptions']['ca'] = 'Classified then Auction Count';
			$tpl_vars['countOptions']['ac'] = 'Auction then Classified Count';
			$tpl_vars['countOptions']['all'] = 'Combined Count';
		}
		
		$view = geoView::getInstance();
		$view->setBodyVar($tpl_vars)
			->setBodyTpl('admin/settings.tpl',$this->name);
	}
	
	public function update_addon_geographic_navigation_settings ()
	{
		$settings = $_POST['settings'];
		
		if (isset($settings['columns'])) {
			$reg = geoAddon::getRegistry('geographic_navigation');
			
			$reg->columns = (intval($settings['columns']) > 0)? intval($settings['columns']): 1;
			
			$validTree = array ('compact', 'full');
			
			$reg->tree = (in_array($settings['tree'], $validTree))? $settings['tree']: false;
			$reg->userUse = (isset($settings['userUse']) && $settings['userUse'])? 1: false;
			$reg->userRequire = (isset($settings['userRequire']) && $settings['userRequire'])? 1: false;
			$reg->userEndRequire = (isset($settings['userEndRequire']) && $settings['userEndRequire'])? 1: false;
			$reg->showSubs = (isset($settings['showSubs']) && $settings['showSubs'])? 1: false;
			$reg->alpha_across_columns = (isset($settings['alpha_across_columns']) && $settings['alpha_across_columns'])? 1: false;
			$reg->combineTree = (isset($settings['combineTree']) && $settings['combineTree'])? 1 : false;
			$reg->showInSearchBox = (isset($settings['showInSearchBox']) && $settings['showInSearchBox'])? 1 : false;
			$reg->showInTitleListing = (isset($settings['showInTitleListing']) && $settings['showInTitleListing'])? 1 : false;
			$reg->showInTitle = (isset($settings['showInTitle']) && $settings['showInTitle'])? 1 : false;
			
			if ($settings['countFormat']=='0') {
				$settings['countFormat'] = false;
			}
			$reg->countFormat = $settings['countFormat'];
			
			$reg->save();
		}
		
		return true;
	}

	public function init_text ($languageId)
	{
		$text = array
		(
			'currentRegion' => array (
				'name' => 'Current Region',
				'desc' => 'Used when displaying the Addon tag.',
				'type' => 'input',
				'default' => 'Region:'
			),
			'allRegions' => array (
				'name' => 'All Regions link',
				'desc' => 'Used when displaying the Addon tag.',
				'type' => 'input',
				'default' => 'All Regions'
			),
			'selectRegions' => array (
				'name' => 'Select Region text',
				'desc' => 'Used in select drop-down.',
				'type' => 'input',
				'default' => 'Select'
			),
			'allRegionsSelect' => array (
				'name' => 'All Regions select text',
				'desc' => 'Used in select drop-down specifically in search box.',
				'type' => 'input',
				'default' => 'All Regions'
			),
			'noRegions' => array (
				'name' => 'No Regions text',
				'desc' => 'Used if there are no regions at current level.  Make blank to not display any message.',
				'type' => 'input',
				'default' => 'There are no sub-regions at this level.'
			),
			'userInfoLocationLabel' => array (
				'name' => 'Location Label in User Info',
				'desc' => '',
				'type' => 'input',
				'default' => 'Location'
			),
			'userInfoEditLocationLabel' => array (
				'name' => 'Location Label in Edit User Info',
				'desc' => '',
				'type' => 'input',
				'default' => 'Location'
			),
			'detailsLocationLabel' => array (
				'name' => 'Location Label in Listing Detail Collection',
				'desc' => '',
				'type' => 'input',
				'default' => 'Location'
			),
			'registerLocationLabel' => array (
				'name' => 'Location Label in Registration',
				'desc' => '',
				'type' => 'input',
				'default' => 'Location'
			),
			'searchLocationLabel' => array (
				'name' => 'Location Label in Advanced Search',
				'desc' => '',
				'type' => 'input',
				'default' => 'Location'
			),
			'browsingHeader' => array ( 
				'name' => 'Browsing Listings Header Text',
				'desc' => '',
				'type' => 'input',
				'default' => 'Geographic Location'
			),
			
			//ERRORS ::
			
			'errorListingRequired' => array (
				'name' => 'Location Required error message (Listing)',
				'desc' => '',
				'type' => 'input',
				'default' => 'Location is Required.'
			),
			'errorUserRequired' => array (
				'name' => 'Location Required error message (User)',
				'desc' => '',
				'type' => 'input',
				'default' => 'Location is Required.'
			),
			'errorListingEndRequired' => array (
				'name' => 'Location terminal-level Required error message (Listing)',
				'desc' => '',
				'type' => 'input',
				'default' => 'Full Location Depth is Required.'
			),
			'errorUserEndRequired' => array (
				'name' => 'Location terminal-level Required error message (user)',
				'desc' => '',
				'type' => 'input',
				'default' => 'Full Location Depth is Required.'
			),
		);
		return $text;
	}
}