// $Rev: 21275 $

var addonGeographic = {
	
	initRegions : function () {
		$$('.geographicAddonExpand').each(function (element) {
			//get rid of any existing
			element.stopObserving('click');
			//add observer for clicky
			element.observe('click', function () {
				if (!this.up() || !this.up().next()) {
					//could not find element to show
					return;
				}
				var child = this.up().next();
				
				if (child) {
					child.toggle();
					
					if (child.visible()) {
						if (child.hasClassName('notRetrieved')) {
							//remove class name
							child.removeClassName('notRetrieved');
							
							//now see if child is state or another level
							if (child.hasClassName('isCountry')) {
								//it's a country, populate it with states
								new Ajax.Updater(child, 'AJAX.php?controller=addon_geographic_navigation&action=getStatesFor',{
									parameters: {country_id: child.identify()},
									evalScripts : true
								});
							} else if (child.hasClassName('isState')) {
								//it's a state, populate it with addon regions
								new Ajax.Updater(child, 'AJAX.php?controller=addon_geographic_navigation&action=getRegionsFor',{
									parameters: {state_id: child.identify()},
									evalScripts : true
								});
							} else {
								//it's an addon region, populate it with child regions
								new Ajax.Updater(child, 'AJAX.php?controller=addon_geographic_navigation&action=getRegionsFor',{
									parameters: {region_id: child.identify()},
									evalScripts : true
								});
							}
						}
						addonGeographic.changeToMinus(this);
					} else {
						addonGeographic.changeToPlus(this);
					}
				}
			});
		});
		
		//observe checkboxes
		$$('.regionCheckBox').each(function (element) {
			element.stopObserving('click');
			addonGeographic.updateChecked(element);
			element.observe('click', function (action) {
				addonGeographic.updateChecked(this);
				var url='AJAX.php?controller=addon_geographic_navigation&action=updateChecked';
				var rtype = '';
				if (this.hasClassName('isCountry')) {
					rtype = 'country';
				} else if (this.hasClassName('isState')) {
					rtype = 'state';
				}
				//submit
				
				new Ajax.Request( url,{
					method: 'post',
					parameters : {
						region_id : this.value,
						checked : (this.checked)?1:0,
						type : rtype
					}
				});
			});
		});
		
		//observe forms
		$$('form.newRegionForm').each (function (element) {
			element.stopObserving('submit');
			element.observe('submit', function (action) {
				//stop the submit
				action.stop();
				
				var updateBox = this.up().up().up().up().up();
				
				//do an ajax call
				this.request({
					onComplete: function (transport) {
						updateBox.update(transport.responseText);
					}
				});
			});
		});
		$$('form.editRegionForm').each (function (element) {
			element.stopObserving('submit');
			element.observe('submit', function (action) {
				//stop the submit
				action.stop();
				
				var updateBox = this.up().up().up().up().up();
				
				//do an ajax call
				this.request({
					onComplete: function (transport) {
						updateBox.update(transport.responseText);
					}
				});
			});
		});
		$$('form.deleteRegionForm').each (function (element) {
			element.stopObserving('submit');
			element.observe('submit', function (action) {
				//stop the submit
				action.stop();
				var warning = "Are you sure?  This will also delete all regions below this one.";
				if (!confirm(warning)) {
					return;
				}
				var updateBox = this.up().up().up().up().up();
				
				//do an ajax call
				this.request({
					onComplete: function (transport) {
						updateBox.update(transport.responseText);
					}
				});
			});
		});
		
		
		
		//observe buttons
		$$('input.editRegionButton').each(function (element){
			element.stopObserving('click');
			element.observe('click',function (action) {
				action.stop();
				this.up().hide();
				this.up().next().show();
			});
		});
		$$('input.cancelRegionButton').each(function (element){
			element.stopObserving('click');
			element.observe('click',function (action) {
				action.stop();
				this.up().up().hide();
				this.up().up().previous().show();
			});
		});
		
		//start sortables
		var regions = $$('ul.isRegion');
		//have to reverse them because the childs needs to be first
		regions.reverse();
		regions.each(function (element) {
			Sortable.create(element, {
				handle : 'regionNameHook',
				only : 'regionMovable',
				onUpdate : addonGeographic.changeOrder
			});
		});
	},
	updateChecked : function (element) {
		var child = element.up().up().next();
		var expandButton = element.up().previous();
		
		if (element.checked) {
			expandButton.show();
		} else {
			child.hide();
			addonGeographic.changeToPlus(expandButton);
			expandButton.hide();
		}
	},
	
	changeToPlus : function (element) {
		element = $(element);
		element.select('.minus')[0].hide();
		element.select('.plus')[0].show();
	},
	changeToMinus : function (element) {
		element = $(element);
		element.select('.plus')[0].hide();
		element.select('.minus')[0].show();
	},
	
	changeOrder : function (element) {
		new Ajax.Request("AJAX.php?controller=addon_geographic_navigation&action=sortRegions", {
			method: 'post',
			parameters: {'regions': Sortable.serialize(element.identify())}
		});
	}
		
};

Event.observe(window, 'load', function () {
	addonGeographic.initRegions();
});
