<?php
//geographic_navigation/ADMIN.ajax.php
/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21275              $ ##
## File last change date:       ##
##  $Date:: 2011-04-22 17:08:#$ ##
##                              ##
##################################

if(class_exists( 'admin_AJAX' ) or die());

class addon_geographic_navigation_ADMIN_ajax extends admin_AJAX {
	private $name = 'geographic_navigation';
	
	private function _displayRegions ($parent_region, $parent_state)
	{
		$parent_region = (int)$parent_region;
		$parent_state = (int)$parent_state;
		
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		$util = geoAddon::getUtil('geographic_navigation');
		$reg = geoAddon::getRegistry ('geographic_navigation');
		
		$sql = "SELECT * FROM ".addon_geographic_navigation_info::REGION_TABLE."
			WHERE `parent_state`=? AND `parent_region`=?
			ORDER BY `display_order`,`label`";
		$all = $db->GetAll($sql, array($parent_state, $parent_region)); 
		
		$tpl = new geoTemplate('addon','geographic_navigation');
		
		$regions = array();
		$level = $util->getLevelNumber($parent_state, $parent_region);
		foreach($all as $region) {
			$regions[] = array (
				'id' => $region['id'],
				'name' => geoString::fromDB($region['label']),
				'level' => "Region Level $level",
				'parent_region' => $region['parent_region'],
				'parent_state' => $region['parent_state'],
				'subdomain' => $region['subdomain'],
				'childClass' => 'isRegion'
			);
		}
		//add one for new
		$regions[] = array (
			'id' => 'new',
			'parent_state' => $parent_state,
			'parent_region' => $parent_region,
			'childClass' => 'isRegion',
			'level' => "region level $level"
		);
		$tpl->regions = $regions;
		$tpl->ajax = 1;
		$tpl->subdomains = $reg->subdomains;
		$tpl->domain = $util->getDomain();
		if ($level == 1) {
			//uses uregions at top
			$tpl->uregions = $regions;
			echo $tpl->fetch('admin/top_regions.tpl');
		} else {
			echo $tpl->fetch('admin/regions_list.tpl');
		}
		return true;
	}
	
	public function getStatesFor ()
	{
		if (!$this->canDisplay('geographic_addon_regions')) {
			echo 'You do not have permission to view this page.';
			return;
		}
		
		$country_id = (int)str_replace('subRegion_','',$_POST['country_id']);
		if (!$country_id) {
			//oops, no good
			echo 'Not valid? '.$_POST['country_id'];
			return;
		}
		
		$tpl = new geoTemplate('addon','geographic_navigation');
		
		$region = geoRegion::getInstance();
		$reg = geoAddon::getRegistry ('geographic_navigation');
		$util = geoAddon::getUtil('geographic_navigation');
		
		$all = $region->getSubRegionList($country_id,'',true);
		$regions = array();
		
		foreach($all as $region) {
			$regions[] = array (
				'id' => $region['state_id'],
				'name' => $region['name'],
				'level' => 'State/Province',
				'subdomain' => $region['subdomain'],
				'on_off_value' => (($region['addon_geographic_navigation_used'])? true: false),
				'childClass' => 'isState',
				'country_id' => $region['parent_id']
			);
		}
		$tpl->regions = $regions;
		$tpl->ajax = 1;
		$tpl->subdomains = $reg->subdomains;
		$tpl->domain = $util->getDomain();
		echo $tpl->fetch('admin/regions_list.tpl');
	}
	
	public function getRegionsFor ()
	{
		if (!$this->canDisplay('geographic_addon_regions')) {
			echo 'You do not have permission to view this page.';
			return;
		}
		
		$state_id = (int)str_replace('subRegion_','',$_POST['state_id']);
		$region_id = (int)str_replace('subRegion_','',$_POST['region_id']);
		
		if (!$this->_displayRegions($region_id, $state_id)) {
			//let it know where the line is
			echo '-'.__line__;
		}
	}
	
	public function addNewRegion ()
	{
		if (!$this->canUpdate('geographic_addon_regions')) {
			echo 'You do not have permission to add region.';
			return;
		}
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		$reg = geoAddon::getRegistry('geographic_navigation');
		$util = geoAddon::getUtil('geographic_navigation');
		
		$parent_state = (int)$_POST['parent_state'];
		$parent_region = (int)$_POST['parent_region'];
		
		if ($reg->subdomains && isset($_POST['subdomain'])) {
			$subdomain = $orig = $_POST['subdomain'];
			//clean it up
			$subdomain = $util->subdomainClean($subdomain);
			
			if ($subdomain != $orig) {
				//let them know it was cleaned up...  or not...
				//echo "Subdomain cleaned of invalid characters.<br />";
			}
			
			if (strlen($subdomain)) {
				//make sure it does not match something already in system...
				$count = (int)$db->GetOne("SELECT COUNT(*) FROM ".addon_geographic_navigation_info::REGION_TABLE."
					WHERE `subdomain`=?", array($subdomain));
				
				//count in countries as well
				$count += (int)$db->GetOne("SELECT COUNT(*) FROM ".geoTables::countries_table."
					WHERE `subdomain`=?", array($subdomain));
				
				//also count in states
				$count += (int)$db->GetOne("SELECT COUNT(*) FROM ".geoTables::states_table."
					WHERE `subdomain`=?", array($subdomain));
				
				if ($count > 0) {
					//oops, can't do that, already another one with same
					echo "Cannot use same subdomain ($subdomain) for multiple regions!  Refresh page to continue.";
					return;
				}
			}
		}
		
		//make sure parent is valid
		if ($parent_state) {
			$sql = "SELECT `state_id` FROM ".geoTables::states_table." WHERE `state_id`=?";
			$row = $db->GetRow($sql, array($parent_state));
			if (!isset($row['state_id']) || $row['state_id'] != $parent_state) {
				//oopsy!
				echo 'Invalid parent state ID specified'.__line__;
				return;
			}
			if ($parent_region) {
				//can't have state and region
				echo 'Error, invalid input'.__line__;
				return;
			}
		}
		if ($parent_region) {
			//varify the parent region exists
			$sql = "SELECT `id` FROM ".addon_geographic_navigation_info::REGION_TABLE." WHERE `id`=?";
			$row = $db->GetRow($sql, array($parent_region));
			if (!isset($row['id']) || $row['id'] != $parent_region) {
				//oopsy!
				echo 'Invalid parent region ID specified'.__line__;
				return;
			}
		}
		$label = trim($_POST['label']);
		//make sure there are no other regions at this level with same label
		$sql = "SELECT `id` FROM ".addon_geographic_navigation_info::REGION_TABLE."
			WHERE `label`=? AND `parent_state`=? AND `parent_region`=?";
		$row = $db->GetRow($sql, array(geoString::toDB($label), $parent_state, $parent_region));
		if (isset($row['id']) && $row['id']) {
			//oops!
			echo 'Error: Can not have region at same level with same name.  Refresh page to continue.';
			return;
		}
		
		//get next highest display order
		$display_order = 1;
		$sql = "SELECT MAX(`display_order`) as display_order FROM ".addon_geographic_navigation_info::REGION_TABLE."
			WHERE `parent_region`=? AND `parent_state`=?";
		$row = $db->GetRow($sql, array($parent_region, $parent_state));
		if (isset($row['display_order']) && $row['display_order'] >= $display_order) {
			$display_order = $row['display_order']+1;
		}
		
		$extra = '';
		$sql_data = array($parent_region, $parent_state, geoString::toDB($label), $display_order);
		if ($reg->subdomains && isset($subdomain) && $subdomain) {
			$extra1 = ", `subdomain`";
			$extra2 = ", ?";
			$sql_data = array($parent_region, $parent_state, geoString::toDB($label), $subdomain, $display_order);
		}
		
		//insert it..
		
		
		$sql = "INSERT INTO ".addon_geographic_navigation_info::REGION_TABLE."
			(`parent_region`, `parent_state`, `label`$extra1, `display_order`)
			VALUES (?, ?, ?$extra2, ?)";
		
		$result = $db->Execute($sql, $sql_data);
		if (!$result) {
			echo "Error inserting in DB!";
			return;
		}
		
		////////////////////
		$id = $db->Insert_Id();
		if (!$id) {
			echo 'ID not found!';
			return;
		}
		if (!$this->_displayRegions($parent_region, $parent_state)) {
			//let it know where the line is
			echo '-'.__line__;
		}
	}
	
	public function editRegion ()
	{
		if (!$this->canUpdate('geographic_addon_regions')) {
			echo 'You do not have permission to edit region.';
			return;
		}
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		$reg = geoAddon::getRegistry('geographic_navigation');
		$util = geoAddon::getUtil('geographic_navigation');
		
		$region_id = (int)$_POST['region_id'];
		$label = trim($_POST['label']);
		
		$childClass = $_POST['childClass'];
		
		if ($reg->subdomains && isset($_POST['subdomain'])) {
			$subdomain = $orig = $_POST['subdomain'];
			//clean it up
			$subdomain = $util->subdomainClean($subdomain);
			
			if ($subdomain != $orig) {
				//let them know it was cleaned up...  or not...
				//echo "Subdomain cleaned of invalid characters.<br />";
			}
			
			if (strlen($subdomain) && $region_id) {
				if ($util->subdomainUsed($subdomain, $childClass, $region_id)) {
					//oops, can't do that, already another one with same
					echo "Cannot use same subdomain ($subdomain) for multiple regions!";
					//basically, unset it, so subdomain is not affected
					unset($subdomain);
				}
			}
		}
		
		if (!$region_id) {
			//oops!
			echo "Invalid region ID specified!".__line__;
		} else if (!$label && $childClass == 'isRegion') {
			echo "Name required!".__line__;
		} else {
			//They can have label with same name when editing if they really want,
			//it doesn't actually hurt anything, just makes things more confusing,
			//don't bother checking for it...
			
			
			//update it
			if ($childClass == 'isRegion') {
				$extra = '';
				$sql_data = array(geoString::toDB($label), $region_id);
				if ($reg->subdomains && isset($subdomain)) {
					$extra = ", `subdomain`=?";
					$sql_data = array(geoString::toDB($label), $subdomain, $region_id);
				}
				
				$sql = "UPDATE ".addon_geographic_navigation_info::REGION_TABLE." SET
					`label`=?$extra WHERE `id`=?";
			} else if ($childClass == 'isCountry' && isset($subdomain)) {
				$sql = "UPDATE ".geoTables::countries_table." SET
					`subdomain`=? WHERE `country_id`=?";
				$sql_data = array ($subdomain, $region_id);
			} else if ($childClass == 'isState' && isset($subdomain)) {
				$sql = "UPDATE ".geoTables::states_table." SET
					`subdomain`=? WHERE `state_id`=?";
				$sql_data = array ($subdomain, $region_id);
			} else {
				//probably subregions got turned off before this was called or something
				echo "No changes to make!  Refresh page to continue.";
				return;
			}
			
			$result = $db->Execute($sql, $sql_data);
			if (!$result) {
				echo "Error updating in DB!";
				return;
			}
		}
		
		$tpl = new geoTemplate('addon','geographic_navigation');
		
		$parent_state = (int)$_POST['parent_state'];
		$parent_region = (int)$_POST['parent_region'];
		
		if ($childClass == 'isState') {
			//show list of states
			$this->getStatesFor();
		} else if ($childClass == 'isCountry') {
			//hmm show countries?
			$this->_showCountries();
			
		} else if (!$this->_displayRegions($parent_region, $parent_state)) {
			//let it know where the line is
			echo '-'.__line__;
		}
	}
	
	private function _showCountries ()
	{
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		$view = geoView::getInstance();
		
		//get all the main regions
		$region = geoRegion::getInstance();
		$reg = geoAddon::getRegistry($this->name);
		$util = geoAddon::getUtil($this->name);
		
		$all = $region->getRegionsList('',true);
		
		$regions = array();
		
		foreach($all as $id => $regionData) {
			$regions[] = array (
				'id' => $id,
				'name' => $regionData['name'],
				'subdomain' => $regionData['subdomain'],
				'level' => 'Country',
				'on_off' => true,
				'on_off_value' => (($regionData['addon_geographic_navigation_used'])? true: false),
				'childClass' => 'isCountry'
			);
		}
		
		$tpl_vars = array ();
		$tpl_vars['regions'] = $regions;
		$tpl_vars['subdomains'] = $reg->subdomains;
		$tpl_vars['domain'] = $util->getDomain();
		$tpl_vars['ajax'] = 1;
		
		$tpl = new geoTemplate(geoTemplate::ADDON, 'geographic_navigation');
		$tpl->assign($tpl_vars);
		echo $tpl->fetch('admin/countries.tpl');
	}
	
	private function _deleteRegion ($regionId) {
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		$regionId = (int)$regionId;
		if (!$regionId) {
			echo 'invalid id'.__line__."<br />";
			return false;
		}
		//get all the parents
		$sql = "SELECT `id` FROM ".addon_geographic_navigation_info::REGION_TABLE."
			WHERE `parent_region`=?";
		$all = $db->GetAll($sql, $regionId);
		foreach ($all as $row) {
			if ((int)$row['id']) {
				//delete it
				if (!$this->_deleteRegion($row['id'], true)) {
					echo "Error deleting page.".__line__."<br />";
					return false;
				}
			}
		}
		//delete this particular one
		$sql = "DELETE FROM ".addon_geographic_navigation_info::REGION_TABLE."
			WHERE `id`=? LIMIT 1";
		
		$result = $db->Execute($sql, array($regionId));
		if (!$result) {
			echo "DB Error! ".__line__."<br />";
			return false;
		}
		return true;
	}
	public function deleteRegion ()
	{
		if (!$this->canUpdate('geographic_addon_regions')) {
			echo 'You do not have permission to edit region.';
			return false;
		}
		
		$regionId = (int)$_POST['region_id'];
		if (!$regionId) {
			//oops!
			echo "Invalid region ID specified!".__line__;
			return false;
		}
		
		$this->_deleteRegion($regionId);
		
		//update stuff
		$parent_state = (int)$_POST['parent_state'];
		$parent_region = (int)$_POST['parent_region'];
		
		if (!$this->_displayRegions($parent_region, $parent_state)) {
			//let it know where the line is
			echo '-'.__line__;
		}
	}
	
	public function updateChecked ()
	{
		if (!$this->canUpdate('geographic_addon_regions')) {
			echo 'You do not have permission to edit region.';
			return false;
		}
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		$regionId = (int)$_POST['region_id'];
		$checked = ($_POST['checked'])? 1: 0;
		$type = trim($_POST['type']);
		echo "region $regionId checked $checked type $type";
		if (!$regionId) {
			//invalid ID specified.
			return;
		}
		
		if ($type == 'country') {
			//update country
			$table = geoTables::countries_table;
			$field = "`country_id`";
		} else {
			$table = geoTables::states_table;
			$field = "`state_id`";
		}
		$sql = "UPDATE $table SET `".addon_geographic_navigation_info::COLUMN_NAME."`=?
				WHERE $field=?";
		$db->Execute($sql, array($checked, $regionId));
	}
	
	public function selectRegion ()
	{
		$util = geoAddon::getUtil('geographic_navigation');
		$util->ajaxSelectRegion();
	}
	
	public function sortRegions ()
	{
		if (!$this->canUpdate('geographic_addon_regions')) {
			echo 'You do not have permission to edit region.';
			return false;
		}
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		parse_str($_POST['regions'], $inputData);
		
		$regions = array_pop($inputData);
		
		if (!$regions) {
			//error
			echo 'Data invalid, refresh page.';
			return;
		}
		
		//sort things
		
		foreach ($regions as $order => $id) {
			$sql = "UPDATE ".addon_geographic_navigation_info::REGION_TABLE." SET `display_order`=?
				WHERE `id`=?";
			
			$displayOrder = $order + 1;
			if (!$db->Execute($sql, array ((int)$displayOrder, (int)$id))) {
				echo "error: ".$db->ErrorMsg()."\n";
			}
			echo "Updated $id to order $displayOrder\n";
		}
		echo 'Sorting finished.';
	}
}