<?php 
//addons/contact_us/pages.php
/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 21384              $ ##
## File last change date:       ##
##  $Date:: 2011-05-10 16:22:#$ ##
##                              ##
##################################

# Contact us addon

require_once ADDON_DIR . 'contact_us/info.php';

class addon_contact_us_pages extends addon_contact_us_info
{
	public function main ()
	{
		$db = 1;
		include GEO_BASE_DIR . 'get_common_vars.php';
		
		$showForm = true;//whether or not to show the form
		$errors = $tpl_vars = array();
		$reg = geoAddon::getRegistry($this->name);
		
		if ($reg->show_ip) {
			$tpl_vars['ip'] = $ip = $_SERVER['REMOTE_ADDR'];
		}
		
		$tpl_vars['msgs'] = geoAddon::getText($this->auth_tag, $this->name);
		
		$secure = geoAddon::getUtil('security_image');
		
		if (isset($_POST['contact'])) {
			$contact = $_POST['contact'];
			
			if ($secure && $secure->check_setting('messaging')) {
				if (!$secure->check_security_code($_POST['c']["securityCode"])) {
					$security_text = geoAddon::getText('geo_addons','security_image');
					
					$errors['securityCode'] = $security_text['error'];
				}
			}
			
			$dept = $tpl_vars['vals']['dept'] = (in_array($contact['dept'], array(1,2)))? (int)$contact['dept'] : false;
			if (!$dept) {
				$errors['dept'] = $tpl_vars['msgs']['error_dept'];
			}
			
			//name - not required
			$name = $tpl_vars['vals']['name'] = trim($contact['name']);
			
			//email - required
			$email = $tpl_vars['vals']['email'] = trim($contact['email']);
			if (!$email) {
				$errors['email'] = $tpl_vars['msgs']['error_email_blank'];
			} else if (!geoString::isEmail($email)) {
				$errors['email'] = $tpl_vars['msgs']['error_email_invalid'];
			}
			
			//subject - required
			$subject = $tpl_vars['vals']['subject'] = preg_replace('/[\n\r\t]+/','',trim($contact['subject']));
			
			if (!$subject) {
				$errors['subject'] = $tpl_vars['msgs']['error_subject'];
			}
			
			//message - required
			$message = $tpl_vars['vals']['message'] = trim($contact['message']);
			if (!$message) {
				$errors['message'] = $tpl_vars['msgs']['error_message'];
			}
			
			$username = geoSession::getInstance()->getUsername();
			
			if (count($errors) == 0) {
				//no errors, send e-mail
				$showForm = false;
				
				$email_subject = $reg->get('subject_prefix','contact us - ').$subject;
				$tpl = new geoTemplate('addon','contact_us');
				$mailVars = array();
				$mailVars['ip'] = $ip;
				$mailVars['name'] = $name;
				$mailVars['email'] = $email;
				$mailVars['subject'] = $subject;
				$mailVars['message'] = $message;
				$mailVars['username'] = geoSession::getInstance()->getUsername();
				$mailVars['show_ip'] = $reg->show_ip;
				$mailVars['dept'] = 'Department '.$dept.' - '.$mailVars['msgs']['dept_'.$dept];
				$tpl->assign($mailVars);
				$email_message = $tpl->fetch('emails/contact.tpl');
				
				$to_emails = explode(',',$reg->get('dept_'.$dept.'_email', $db->get_site_setting('site_email')));
				//send the e-mail, as an HTML e-mail
				geoEmail::sendMail($to_emails, $email_subject, $email_message, 
					$db->get_site_setting('site_email'), $email, 0, 'text/html');
			}
		}
		$tpl_vars['show_ip'] = $reg->show_ip;
		
		if ($secure && $secure->check_setting('messaging')) {
			$security_text = geoAddon::getText('geo_addons','security_image');
			$error = $errors['securityCode'];
			$section = "message";
			$tpl_vars['security_image'] = $secure->getHTML($error, $security_text, $section, false);
			geoView::getInstance()->addTop($secure->getJs());		
		}
		
		$tpl_vars['errors'] = $errors;
		$tpl = ($showForm)? 'contact_form.tpl' : 'contact_success.tpl';
		geoView::getInstance()->setBodyTpl($tpl,'contact_us')
			->setBodyVar($tpl_vars);
	}
}