<?php
//_bidpay_client.php
/**************************************************************************
Geodesic Classifieds & Auctions Platform 5.2
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev::                    $ ##
## File last change date:       ##
##  $Date::                   $ ##
##                              ##
##################################

geoUtil::includePEAR('SOAP/Client.php');
geoUtil::includePEAR('SOAP/Type/dateTime.php');

//************Classes******************//

class bidpayClient extends SOAP_Client
{
	var $apiUrl = 'sandbox.api.bidpay.com';
	//var $apiUrl = 'api.bidpay.com';

	var $_timeout = 30;
	
	function __construct()
	{
		$path = 'https://'.$this->apiUrl.'/ThirdPartyPayment/v1/ThirdPartyPaymentService.asmx';
		
		$this->SOAP_Client($path, 0);
		$this->setEncoding('utf-8');
		$this->setTrace(true);
		//$this->setOpt('curl', CURLOPT_VERBOSE, 1);
		
		//$this->setOpt('curl', CURLOPT_CONNECTTIMEOUT, 30);
		//$this->setOpt('curl', CURLOPT_TIMEOUT, 30);
		
	}
	function &ThirdPartyPayment($ThirdPartyPaymentRequest)
	{
		// ThirdPartyPaymentRequest is a ComplexType, refer to the WSDL for more info.
		$ThirdPartyPaymentRequest_attr['xmlns'] = 'http://api.bidpay.com/ThirdPartyPayment/v1/Messages/ThirdPartyPaymentRequest-1-0';
		$ThirdPartyPaymentRequest = new SOAP_Value('ThirdPartyPaymentRequest', false, $ThirdPartyPaymentRequest, $ThirdPartyPaymentRequest_attr);
		$result = $this->call(
			'ThirdPartyPayment',
			$v = array(
				'ThirdPartyPaymentRequest' => $ThirdPartyPaymentRequest
			),
			array(
				'namespace' => 'http://api.bidpay.com/ThirdPartyPayment/v1',
				'soapaction' => 'http://api.bidpay.com/ThirdPartyPayment/v1/Methods/PaymentRequest',
				'style' => 'document',
				'use' => 'literal',
				'timeout' => 30//$this->_timeout
			)
		);
		return $result;
	}
	function &ThirdPartyPaymentStatus($ThirdPartyPaymentStatusRequest)
	{
		// ThirdPartyPaymentStatusRequest is a ComplexType, refer to the WSDL for more info.
		$ThirdPartyPaymentStatusRequest_attr['xmlns'] = 'http://api.bidpay.com/ThirdPartyPayment/v1/Messages/ThirdPartyPaymentStatusRequest-1-0';
		$ThirdPartyPaymentStatusRequest = new SOAP_Value('ThirdPartyPaymentStatusRequest', false, $ThirdPartyPaymentStatusRequest, $ThirdPartyPaymentStatusRequest_attr);
		$result = $this->call('ThirdPartyPaymentStatus',
							  $v = array('ThirdPartyPaymentStatusRequest' => $ThirdPartyPaymentStatusRequest),
							  array('namespace' => 'http://api.bidpay.com/ThirdPartyPayment/v1',
									'soapaction' => 'http://api.bidpay.com/ThirdPartyPayment/v1/Methods/PaymentStatusRequest',
									'style' => 'document',
									'use' => 'literal'));
		return $result;
	}

	//Custom Functions
	function _resetNamespaces(){
		$this->_namespaces = array(
			'http://schemas.xmlsoap.org/soap/envelope/' => 'SOAP-ENV',
			'http://www.w3.org/2001/XMLSchema-instance' => 'xsi',
			'http://www.w3.org/2001/XMLSchema' => 'xsd',
			'http://schemas.xmlsoap.org/ws/2004/08/addressing' => 'wsa', //added - not used?
			'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' => 'wsse', //added
			'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd' => 'wsu', //added
			//'http://schemas.xmlsoap.org/soap/encoding/' => 'SOAP-ENC'
		);

	}
	
	function getCnonce(){
		if (file_exists('/dev/urandom') && $fd = @fopen('/dev/urandom', 'r')) {
			return base64_encode(fread($fd, 32));
		} elseif (file_exists('/dev/random') && $fd = @fopen('/dev/random', 'r')) {
			return base64_encode(fread($fd, 32));
		} else {
			$str = '';
			mt_srand((double)microtime()*10000000);
			for ($i=0; $i<32; $i++) {
				$str .= chr(mt_rand(0, 255));
			}
			return base64_encode($str);
		}
	}

	function makeEnvelope(&$method, &$headers,$encoding = SOAP_DEFAULT_ENCODING,$options = array())
	{
		$xml = SOAP_Client::makeEnvelope($method, $headers, $encoding, $options);
		//fix to replace SOAP-ENV with soap
		$xml = str_replace('SOAP-ENV','soap',$xml);
		return $xml;
	}
	
	function addHeader($soap_value){
		// Add a new header to the message.
		if (is_a($soap_value, 'SOAP_Header')) {
			unset($soap_value->attributes['SOAP-ENV:actor']);//get rid of actor
			
			//echo '<h2>header info</h2><pre>'.htmlspecialchars(print_r($soap_value,1)).'</pre>';
			$this->headersOut[] = $soap_value;
		} elseif (is_array($soap_value)) {
			// name, value, namespace, mustunderstand, actor
			$this->headersOut[] = new SOAP_Header($soap_value[0],
												  null,
												  $soap_value[1],
												  $soap_value[2],
												  $soap_value[3]);
		} else {
			$this->_raiseSoapFault('Invalid parameter provided to addHeader().  Must be an array or a SOAP_Header.');
		}
	}
	function createID() {
		$uuid = md5(uniqid(rand(), true));
    		$guid =  /*'urn:uuid:'.*/substr($uuid,0,8)."-".
				substr($uuid,8,4)."-".
				substr($uuid,12,4)."-".
				substr($uuid,16,4)."-".
				substr($uuid,20,12);
		return $guid;
	}
	
	function _getPaymentUrl($listing_id, $winning_bidder_id, $listing_details, $final_price, $timeout = 30){
		$this->setOpt('curl', CURLOPT_CONNECTTIMEOUT, $timeout);
		$this->setOpt('curl', CURLOPT_TIMEOUT, $timeout);
		
		$this->_timeout = $timeout;
		$sb = geoSellerBuyer::getInstance();
		
		$db = true;
		include GEO_BASE_DIR.'get_common_vars.php';
		//bidpay link not already retrieved, so go get it!
		
		//*****************SOAP Call*******************//
		
		/*  //Class generation
		$wsdl = new SOAP_WSDL('https://sandbox.api.bidpay.com/ThirdPartyPayment/v1/ThirdPartyPaymentService.asmx?WSDL');
		
		echo '<h2>Code</h2><pre>'.htmlspecialchars($wsdl->generateAllProxies()).'</pre>';
		//  */
		
		$ApiUsername = $db->get_site_setting('bidpay_site_username');
		//need to store password in settings_long...
		$ApiPassword = $db->get_site_setting('bidpay_site_pass',true);
		$Site = $db->get_site_setting('bidpay_site');
		
		$currentTime = time() - (60*4);//take off 4 minutes, so the times can be a little off.
		$dateTime = new SOAP_Type_dateTime($currentTime);
		$created = $dateTime->toUTC();
		$expires = $dateTime->toUTC($currentTime+(60*10));//give us 10 minutes
		
		//fix UTC day
		/*
		 * This is a work-around, for this problem:
		 * when the UTC time is past midnight but the local time is
		 * before midnight, so that the UTC day is one day ahead of
		 * the local day:  the UTC time calculated by toUTC() is wrong,
		 * it sets the day to the local day, not the UTC day.
		 * 
		 * Below fixes it, by first detecting if it has happened by converting
		 * the UTC time back to local time, and seeing if it is a day behind.
		 * If it is a day behind, then adjust by adding a day, then converting that
		 * to UTC, to properly get the correct UTC time and day.
		 */
		if (($currentTime - strtotime($created)) > 60 * 60 * 5 ){
			//looks like time got messed up, it's a day too early
			$dateTime = new SOAP_Type_dateTime($currentTime + (60*60*24));// 24 hours in future
			$created = $dateTime->toUTC();
		}
		if (($currentTime - strtotime($expires)) > 60 * 60 * 5 ){
			//looks like time got messed up, it's a day too early
			$dateTime = new SOAP_Type_dateTime($currentTime + (60*60*24) + (60*10));// 24 hours 10 minutes in future
			$expires = $dateTime->toUTC();
		}
		
		//data for listing
		$nonce = $this->getCnonce();
		
		$ReferenceNumber = $sb->getListingSetting($listing_id,'bidpay_ReferenceNumber');//$this->createID();
		if (strlen($ReferenceNumber) == 0){
			$ReferenceNumber = $this->createID();
			$sb->setListingSetting($listing_id,'bidpay_ReferenceNumber',$ReferenceNumber);
		}
		$AuctionBuyerID = $winning_bidder_id;
		$ReturnUrl = $db->get_site_setting('bidpay_site_url').'?a=sb_transaction&action=bidpay_p_result&l_id='.$listing_id;//my current bids page
		$seller_id = $listing_details['seller'];
		$SellerToken = $sb->getUserSetting($seller_id,'bidpay_token');
		if (strlen($SellerToken) == 0){
			//error, seller token is no good.
			return '';
		}
		$Amount = $final_price;
		$ItemNumber = $listing_id;
		$ItemDescription = geoString::fromDB($listing_details['title']);
		
		//get shipping cost
		$ShippingAmount = $this->_getAdditionalFees($listing_details);
		
		$Items = array (
			'Item' => new Soap_Value (
				'Item',
				null,
				null,
				array (
					'ItemNumber' => $ItemNumber,
					'ItemDescription' => $ItemDescription,
					'Amount' => $Amount,
					'ShippingAmount' => $ShippingAmount,
					'Site' => $Site,
					'ItemType' => 'Auction'
				)
			)
		);
		
		
		///////Generate headers
		
		//Action header
		$soapheader = array();
		$soapheader[] = new SOAP_Header (
			"{http://schemas.xmlsoap.org/ws/2004/08/addressing}Action",
			null,
			'http://api.bidpay.com/ThirdPartyPayment/v1/Methods/PaymentRequest'
		);
		//MessageID header
		$soapheader[] = new SOAP_Header (
			"{http://schemas.xmlsoap.org/ws/2004/08/addressing}MessageID",
			null,
			'urn:uuid:'.$this->createID()
		);
		//ReplyTo header
		$soapheader[] = new SOAP_Header (
			"{http://schemas.xmlsoap.org/ws/2004/08/addressing}ReplyTo",
			null,
			array(
				'Address' => new SOAP_Value (
					'{http://schemas.xmlsoap.org/ws/2004/08/addressing}Address',
					null,
					'http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous'
				)
			)
		);
		//To header
		$soapheader[] = new SOAP_Header (
			"{http://schemas.xmlsoap.org/ws/2004/08/addressing}To",
			null,
			'https://'.$this->apiUrl.'/ThirdPartyPayment/v1/ThirdPartyPaymentService.asmx'
		);
		
		//main header
		$soapheader['main'] = new SOAP_Header(
			"{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd}Security",
			"object",
			array(
				"Timestamp" => new Soap_Value(
					"{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp",
					null,
					array (
						"Created" => new Soap_Value (
							"{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Created",
							null,
							$created
						),
						"Expires" => new Soap_Value (
							"{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Expires",
							null,
							$expires
						)
					),
					array (
						'wsu:Id' => 'Timestamp-'.$this->createId()
					)
				),
				"UsernameToken" => new Soap_Value(
					"{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd}UsernameToken",
					null,
					array(
						"Username" => new Soap_Value(
							"{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd}Username",
							null,
							$ApiUsername
						),
						"Password" => new Soap_Value(
							"{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd}Password",
							'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText',
							$ApiPassword,
							array(
								'Type' => 'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText'
							)
						),
						"Nonce" => new Soap_Value (
							"{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd}Nonce",
							null,
							$nonce
						),
						"Created" => new Soap_Value (
							"{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Created",
							null,
							$created//SOAP_Type_dateTime::toString(time())
						)
					),
					array(
						'xmlns:wsu' => 'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd',
						'wsu:Id' => 'SecurityToken-'.$this->createId()
					)
				)
			),
			1
		);
		
		$keys = array_keys($soapheader);
		foreach ($keys as $key){
			if ($key !== 'main'){
				$soapheader[$key]->attributes = array();//remove all attribs
			}
			$this->addHeader($soapheader[$key]);
		}
		
		////////Build Body
		
		$body = array (
			'ReferenceNumber' => new Soap_Value(
				'ReferenceNumber',
				'null',
				$ReferenceNumber
			),
			
			'AuctionBuyerID' => new Soap_Value(
				'AuctionBuyerID',
				'null',
				$AuctionBuyerID
			),
		
			'ReturnUrl' => new Soap_Value(
				'ReturnUrl',
				null,
				$ReturnUrl
			),
			'SellerToken' => new Soap_Value(
				'SellerToken',
				null,
				$SellerToken
			),
			'Items' => new Soap_Value(
				'Items',
				null,
				$Items
			)
		);
		
		$result = $this->ThirdPartyPayment($body);
		if (is_array($result)){
			$current_transactions = $sb->getListingSetting($listing_id,'bidpay_TransactionID');
			if (!is_array($current_transactions)){
				$current_transactions = array();
			}
			//store in array, so that if the thing is sent through multiple times, 
			//it stores transaction id for each one.
			$current_transactions[] = $result['TransactionID'];
			//$sb->setListingSetting($listing_id, 'bidpay_PaymentURL', $result['PaymentURL']);
			$sb->setListingSetting($listing_id, 'bidpay_TransactionID', $current_transactions);
			return $result['PaymentURL'];
			//echo '<h2><a href="'.$result['PaymentURL'].'">Pay Now</a></h2>';
		}
		return ''; //comment this line out to echo debug info.
		
		if (isset($_REQUEST['show_request'])){
			echo $this->getLastRequest();
		} else {
			//echo '<h2><a href="'.$seller_token_URL.'?'.implode('&amp;',$parts).'">Get Seller Token</a></h2>';
		
		
			echo '<h2>Request</h2><pre>'.htmlspecialchars($this->getLastRequest()).'</pre>';
			echo '<h2>Response</h2><pre>'.htmlspecialchars($this->getLastResponse()).'</pre>';
		
			echo '<h2>Result</h2><pre>'.htmlspecialchars(print_r($result,1)).'</pre>';
		}
		
		
		//made it this far, we don't know the payment URL
		return '';
	}
	
	/**
	 * Function to get additional fee text for bidder.
	 */
	function _getAdditionalFees(&$show){
		//display any optional fields that add to the cost.
		if (!geoPC::is_ent()){
			//additional fees is ent only.
			return 0;
		}
		$db = true;
		include GEO_BASE_DIR . 'get_common_vars.php';
		$total = 0;
		
		for ($i = 1; $i < 21; $i++){
			//go through all the optional fields, see if they add cost, and if they do,
			//see if the value actually adds any cost (not 0 or blank field)
			$option = 'optional_field_'.$i;
			//needs to work with either an object, or array...
			$amount = $show[$option];
			if ($db->get_site_setting("use_optional_field_$i")==2 && $amount>0){
				//this optional field needs to be displayed.
				$total += $amount;
			}
		}
		return $total;
	}
	
}