{* 7.3beta3-18-gceb1e67 *}

{$adminMsgs}

<form action="" method="post">

	<fieldset>
		<legend>Embedded Timeline Appearance</legend>
		<div>
				<p class="page_note">
					<strong>IMPORTANT:</strong> These settings will override any defaults or user-selected settings. When creating a timeline widget,
					users have several display options to select from. If you wish to allow the users' choices to take effect, leave these settings blank (or on 0)
				</p>
				
				 
				<div class="{cycle values="row_color1,row_color2"}">
					<div class="leftColumn">
						Maximum number of tweets to show
					</div>
					<div class="rightColumn">
						<input type="text" name="d[tweet_limit]" value="{$config.tweet_limit}" size="4" /> (1-20, or blank for no limit and to show new tweets as they happen)
					</div>
					<div class="clearColumn"></div>
				</div>
							
				<div class="{cycle values="row_color1,row_color2"}">
					<div class="leftColumn">
						Dimensions of Widget
					</div>
					<div class="rightColumn">
						Width: <input type="text" name="d[width]" value="{$config.width}" size="4" id="width" /> pixels (must be between 180 and 520, or blank to allow User Select)<br />
						Height: <input type="text" name="d[height]" value="{$config.height}" size="4" /> pixels (must be greater than 200, or blank to allow User Select)
					</div>
					<div class="clearColumn"></div>
				</div>
				
				<div class="{cycle values="row_color1,row_color2"}">
					<div class="leftColumn">
						Widget Theme
					</div>
					<div class="rightColumn">
						Light or Dark? <select name="d[theme]">
										<option value="">User Selected</option>
										<option value="light" {if $config.theme == 'light'}selected="selected"{/if}>Always Light</option>
										<option value="dark" {if $config.theme == 'dark'}selected="selected"{/if}>Always Dark</option>
									   </select><br />
						Link Color: #<input type="text" id="link_color" name="d[link_color]" onchange="colorizeSwatches()" value="{$config.link_color}" size="6" /> <span id="swatch_link_color" style="border: 1px solid black; padding: 1px; font-size: 12px;">Color Swatch</span><br />
						Border Color: #<input type="text" id="border_color" name="d[border_color]" onchange="colorizeSwatches()" value="{$config.border_color}" size="6" /> <span id="swatch_border_color" style="border: 1px solid black; padding: 1px; font-size: 12px;">Color Swatch</span>
						
					</div>
					<script type="text/javascript">
					colorizeSwatches = function() {
						$('swatch_link_color').style.backgroundColor = "#" + $('border_color').value;
						$('swatch_border_color').style.backgroundColor = "#" + $('link_color').value;
					}
					Event.observe('window','load',colorizeSwatches());
					</script>
					<div class="clearColumn"></div>
				</div>
				
				<div class="{cycle values="row_color1,row_color2"}">
					<div class="leftColumn">
						Chrome Options
					</div>
					<div class="rightColumn">
						See <a href="https://dev.twitter.com/docs/embedded-timelines#customization">this page</a> for a description of these options<br />
						<input type="checkbox" name="d[chrome][noheader]" value="1" {if $config.chrome.noheader}checked="checked"{/if}> noheader<br />
						<input type="checkbox" name="d[chrome][nofooter]" value="1" {if $config.chrome.nofooter}checked="checked"{/if}> nofooter<br />
						<input type="checkbox" name="d[chrome][noborders]" value="1" {if $config.chrome.noborders}checked="checked"{/if}> noborders<br />
						<input type="checkbox" name="d[chrome][noscrollbar]" value="1" {if $config.chrome.noscrollbar}checked="checked"{/if}> noscrollbar<br />
						<input type="checkbox" name="d[chrome][noscrollbar]" value="1" {if $config.chrome.noscrollbar}checked="checked"{/if}> transparent
					</div>
					<div class="clearColumn"></div>
				</div>
		</div>
	</fieldset>
	
	<fieldset>
		<legend>Default Timeline</legend>
		<div>
			<p class="page_note">You can specify a Timeline to be shown on listings where the seller does not specify one of his own. 
			See the Help page for assistance finding the correct values to enter here</p>
			
			<div class="{cycle values="row_color1,row_color2"}">
				<div class="leftColumn">
					Default "href"
				</div>
				<div class="rightColumn">
					<input type="text" name="d[default_href]" value="{$config.default_href}" size="10" />
				</div>
				<div class="clearColumn"></div>
			</div>
			
			<div class="{cycle values="row_color1,row_color2"}">
				<div class="leftColumn">
					Default "widget-data-id"
				</div>
				<div class="rightColumn">
					<input type="text" name="d[default_data_id]" value="{$config.default_data_id}" size="10" />
				</div>
				<div class="clearColumn"></div>
			</div>
		</div>
	</fieldset>	
	
	<div style="margin: 0 auto; width: 200px;"><input type="submit" class="button" name="auto_save" value="Save"/></div>

</form>