<?php
//addons/storefront_directory/admin.php
/*
 * 
 * @package StorefrontDirectoryAddon
 */

/**************************************************************************
Addon Created by Chrisranjana.com
Copyright (c) 2013 info@chrisranjana.com
All rights reserved
http://chrisranjana.com.com
**************************************************************************/


# Storefront Directory Addon

class addon_storefront_directory_admin extends addon_storefront_directory_info
{
	
	public function init_pages ($menuName)
	{
			$title = 'Directory Categories';
			menu_page::addonAddPage('directory_categories','',$title,'storefront_directory', $this->icon_image);
		 $title = 'Enable/Disable';
			menu_page::addonAddPage('enable_disable','',$title,'storefront_directory', $this->icon_image);
			menu_page::addonAddPage('directory_category_delete','directory_categories','Delete Directory Category','storefront_directory',$this->icon_image,'sub_page');

				
	}
	
		public function display_enable_disable()
	
	{
	$admin = geoAdmin::getInstance();
		$db = DataAccess::getInstance();
		$msgs = geoAddon::getText($this->auth_tag, $this->name);
		$tpl_vars = array();
		
		$tpl_vars['admin_msgs'] = geoAdmin::m();
		$tpl_vars['is_ent'] = geoPC::is_ent();
	
	$dbr = $db->GetRow("SELECT directory_enable_categories FROM ".self::SETTINGS_TABLE);
			$tpl_vars['data']['ed'] = intval($dbr['directory_enable_categories']);
			
		geoView::getInstance()->setBodyTpl('directory_categories_ed.tpl','storefront_directory');
	geoView::getInstance()->setBodyVar($tpl_vars);
	
	}
	
	public function update_enable_disable()
	
	{
		$db = DataAccess::getInstance();
		$admin = geoAdmin::getInstance();
		$settings = $_POST['edit'];
		$sql = "UPDATE ".self::SETTINGS_TABLE." set directory_enable_categories = ?";
		$query_data = array(intval($settings['ed']));
	$db->Execute($sql, $query_data);
		
		unset($_POST['edit']);
		unset($_GET['direct_category_id']);
		
		
		return true;
	
	}
	
	public function display_directory_categories ()
	{
	
	    $admin = geoAdmin::getInstance();
		$db = DataAccess::getInstance();
		$msgs = geoAddon::getText($this->auth_tag, $this->name);
		$tpl_vars = array();
		
		$tpl_vars['admin_msgs'] = geoAdmin::m();
		$tpl_vars['is_ent'] = geoPC::is_ent();
	
	
	$sql = "SELECT * FROM ".self::DIRECTORY_CATEGORIES_TABLE." ORDER BY `directory_category_order`";
		$dircats = $db->GetAll($sql);
		$tpl_vars['dircats'] = $dircats;
	
	
	$direct_category_id = $tpl_vars['direct_category_id'] = ((isset($_GET['direct_category_id']))? (int)$_GET['direct_category_id'] : 0);
	
	
	if (isset($_POST['edit'])) {
			$tpl_vars['data'] = $_POST['edit'];
			
			
		} else if ($direct_category_id) {
		
		
			//populate data
			$dbr = $db->GetRow("SELECT * FROM ".self::DIRECTORY_CATEGORIES_TABLE." WHERE `directory_category_id`=?", array($direct_category_id));
			$tpl_vars['data']['name'] = $dbr['directory_category_name'];
			$tpl_vars['data']['description'] = $dbr['directory_category_notes'];
			$tpl_vars['data']['order'] = $dbr['directory_category_order'];
			$tpl_vars['data']['direct_category_id'] = $direct_category_id;
			
			
		}
	
	
	
		geoView::getInstance()->setBodyTpl('directory_categories_admin.tpl','storefront_directory');
	geoView::getInstance()->setBodyVar($tpl_vars);
	}
	
	public function update_directory_categories ()
	
	{
	
		$db = DataAccess::getInstance();
		$admin = geoAdmin::getInstance();
		
		
		
		$settings = $_POST['edit'];
		$direct_category_id = (int)$settings['direct_category_id'];
		//input checking
		$settings['name'] = trim($settings['name']);
		if (!strlen($settings['name'])) {
			$admin->userError('Name is required.');
			return false;
		}
		
		
		
		//check name  make sure it is not duplicate
		$duplicates = $db->GetOne("SELECT COUNT(*) FROM ".self::DIRECTORY_CATEGORIES_TABLE." WHERE `directory_category_id`!=$direct_category_id  AND LOWER(`directory_category_name`)=?",
			array (geoString::toDB(strtolower($settings['name']))));
			
			
		if ($duplicates > 0) {
			$admin->userError('Directory category NAME already in use');
			return false;
		}
		
			
		$query_data = array(
			geoString::toDB($settings['name']), 
			geoString::toDB($settings['description']),
			geoString::toDB($settings['order']),
		);
		if ($direct_category_id) {
			$sql = "UPDATE ".self::DIRECTORY_CATEGORIES_TABLE." SET
				`directory_category_name`=?,
				`directory_category_notes`=?,
				`directory_category_order`=?
				WHERE `directory_category_id`=?";
			$query_data[] = $direct_category_id;
		} else {
			$sql = "INSERT INTO ".self::DIRECTORY_CATEGORIES_TABLE." SET
				`directory_category_name`=?,
				`directory_category_notes`=?,
				`directory_category_order`=?";
		}
		
		$db->Execute($sql, $query_data);
		
		unset($_POST['edit']);
		unset($_GET['direct_category_id']);
		
		
		return true;
	}
	
		public function display_directory_category_delete()
	{
		
		
		$this->display_directory_categories();
	}
	
	public function update_directory_category_delete ()
	{
	
	$db = DataAccess::getInstance();
		$admin = geoAdmin::getInstance();
		
		$directory_category_id = (int)$_GET['c'];
		if (!isset($_POST['page']) && isset($_POST['auto_save']) && $_POST['auto_save'] !='')
		{
		$this->update_directory_categories();
		return true;
		
		}
		$sql = "DELETE FROM ".self::DIRECTORY_CATEGORIES_TABLE." WHERE `directory_category_id` = ?";
		
		$result = $db->Execute($sql, array(intval($directory_category_id)));
		if (!$result) {
			//db error
			return false;
		}
		
		$admin->userSuccess('Subscription choice has been deleted.');
		return true;
		
		
	}

	
	public function init_text($language_id)
	{
		
		return self::$default_addon_text;
	}
	
	
	
	
	
	
}