<?php
//addons/sharing/methods/buzz.php
/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2011 Geodesic Solutions, LLC
All rights reserved
http://geodesicsolutions.com
see license attached to distribution
**************************************************************************/

##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 20779              $ ##
## File last change date:       ##
##  $Date:: 2010-12-29 18:05:#$ ##
##                              ##
##################################

class addon_sharing_method_buzz {
	
	public $name = 'buzz';
	
	/**
	 * Gets the name of any methods that want to be used for this listing id.
	 * Note that this function being called in the first place implies that the listing in question is live and belongs to the current user
	 * @param int $listingId
	 * @return String the name of any available method, sans any formatting
	 */
	public function getMethodsForListing($listingId) {
		
		//we want this to be available for all listings, so simply return the name to show
		$msgs = geoAddon::getText('geo_addons','sharing');
		return $msgs['method_btn_buzz'];
			
	}
	
	/**
	 * Gets the full HTML to show in the "options" block of the main addon page.
	 * This function is responsible for any needed templatization to generate that HTML.
	 * @return String HTML
	 */
	public function displayOptions()
	{
		$data = $_POST;
		$urlToListing = geoFilter::getBaseHref() . DataAccess::getInstance()->get_site_setting('classifieds_file_name').'?a=2&amp;b='.$data['listing'];
				
		$tpl = new geoTemplate('addon','sharing');
		$tpl->listing_url = urlencode($urlToListing);
		$html = $tpl->fetch('methods/buzz_options.tpl');
		return $html;
	}

	public function getShortLink($listingId)
	{
		$tpl = new geoTemplate('addon','sharing');
		$tpl->iconUrl = geoTemplate::getUrl('images','addon/sharing/icon_buzz.png');
		$msgs = geoAddon::getText('geo_addons','sharing'); 
		$tpl->text = $msgs['shortlink_buzz'];
		
		//this is getting urlencoded -- don't html-encode the &
		$urlToListing = geoFilter::getBaseHref() . DataAccess::getInstance()->get_site_setting('classifieds_file_name').'?a=2&b='.$listingId;
		$listing_url = urlencode($urlToListing);
		$tpl->link = 'http://www.google.com/buzz/post?url='.$listing_url;
		
		return $tpl->fetch('shortLink.tpl');
	}
}