<?php
//addons/example/setup.php
/**
 * Optional file.  Used to specify custom routines to run in addition to
 * the built-in addon system management.
 *
 * Can be used for the routines Install/Uninstall, Upgrade, and Enable/Disable
 *
 * Remember to rename the class name, replacing "example" with
 * the folder name for your addon.
 *
 * This file has no PHP5 equivalent in php5_files/ dir.
 *
 * @author Geodesic Solutions, LLC
 * @package example_addon
 */

/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2007 Geodesic Solutions, LLC
All rights reserved
http://www.geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 11282              $ ##
## File last change date:       ##
##  $Date:: 2007-09-17 14:45:#$ ##
##                              ##
##################################

# Example Addon

/**
 * This class is not required. If it, and the function for a particular
 * routine exist, then that function will be called IN ADDITION TO the
 * automated routines of the addon framework.
 *
 * @author Geodesic Solutions, LLC
 * @version $Rev: 11282 $
 * @copyright Copyright (c) 2001-2007 Geodesic Solutions, LLC
 * @package example_addon
 */
class addon_GeoModules_Paypal4Classifieds_setup {

        /**
         * Optional, remove function if not needed.  This is run when an addon is installed.
         *
         * View the source to see an example that
         * sets up a dummy database table.
         *
         * @return boolean True to continue installing the addon, False to halt
         *  installation
         */
        function install () {
                //script to install a fresh copy.
                //for demonstration, this script sets up a dummy database table.

                //get $db connection and $cron object - use get_common_vars.php to be forward compatible
                //see that file for documentation.
                $db = true;
                $cron = true;
                include(GEO_BASE_DIR.'get_common_vars.php');

                //also get an instance of the geoAdmin object, so we can use it
                //to display messages after install is complete.
                if (PHP5_DIR) $admin_page_loader = Singleton::getInstance('geoAdmin');
                else $admin_page_loader =& Singleton::getInstance('geoAdmin');

                //To avoid table name conflicts, make sure to prefix any tables with
                //the module name.

                $sql = "CREATE TABLE `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders` (
                          `listing_id` int(16) NOT NULL DEFAULT '0',
                          `item_count` int(16) DEFAULT NULL,
                          `paypal_address` varchar(64) DEFAULT NULL,
                          PRIMARY KEY (`listing_id`))" ;


                $result = $db->Execute($sql);
                if (!$result){
                        //query failed, display message and return false.
                        $admin_page_loader->userError('Database error creating table `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders`, installation failed.');
                        return false;
                } else {
                        //Normally, you do not need to give this much info, or any info at all, this is
                        //just used to demonstrate the use of the userNotice, userError, and userSuccess methods.
                        $admin_page_loader->userNotice('The table `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders` created successfully.');
                }

                //add a cron task, so that the file cron/example_task.php can be run as a cron task.
                
                $task = 'GeoModules_Paypal4Classifieds:clean_removed_listings';     //The task name.  Must be ADDON_NAME:TASK where the TASK is the
                                                        //filename without the .php.  The task name cannot be more than
                                                        //128 chars.
                                                        
                $type = 'addon';     //2 types, addon or main.  Difference is that for addon type, the file is located
                                    //in addons/ADDON_NAME/cron/ directory, and main type is located 
                                    //in classes/cron/ directory.

                $interval = 86400;    //interval is in seconds, in this case we set it to 1 hour.
                                    //This is used when running the heartbeat cron, the
                                    //heartbeat will see which tasks have not been run in the amount of time specified
                                    //by the task's interval, and run the tasks that need to be run.
                                    //You can also force it to only be run if specifically
                                    //called in a manually set cron job, by setting the interval to -1.
                
                //now set the task, meaning we are adding it to the cron tasks that will be run.
                //Note that the task will only be run if        $task = 'geographic_navigation:geographic_navigation_task';     //The task name.  Must be ADDON_NAME:TASK where the TASK is the
                // the proper file exists, and the addon is enabled.
                //it is a good idea to also remove the task during the uninstall routine.
                $cron_add = $cron->set($task, $type, $interval);
                
                if (!$cron_add){
                    //failed to add task, display message and return false.
                    $admin_page_loader->userError('geoCron task failed to be added.');
                    return false;
                } else {
                    //let user know cron task addition was successful
                    $admin_page_loader->userNotice('geoCron task for addon was added.');
                }


                return true;
        }

        /**
         * Optional, remove function if not needed.  This is run when an addon is un-installed.
         *
         * View the source to see an example that
         * removes the dummy database table that was
         * created in the example install routine.
         *
         * @return boolean True to continue un-installing the addon, False to halt
         *  un-install
         */
        function uninstall (){
                //script to uninstall the example addon.

                //get $db connection and $cron object - use get_common_vars.php to be forward compatible
                //see that file for documentation.
                $db = true;
                $cron = true;
                include(GEO_BASE_DIR.'get_common_vars.php');

                
                
                //also get an instance of the geoAdmin object, so we can use it
                //to display messages after install is complete.
                if (PHP5_DIR) $admin_page_loader = Singleton::getInstance('geoAdmin');
                else $admin_page_loader =& Singleton::getInstance('geoAdmin');

                $task = 'GeoModules_Paypal4Classifieds:clean_removed_listings';
                $cron_rem = $cron->rem($task);
                
                if (!$cron_rem)
                {
                    $admin_page_loader->userError('Error removing geoCron task');
                    return false;
                }
                else
                {
                    $admin_page_loader->userNotice('geoCron task removed successfully.');
                }


                $sql = 'DROP TABLE IF EXISTS `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders`';
                $result = $db->Execute($sql);
                if (!$result){
                        //query failed, display message and return false.
                        $admin_page_loader->userError('Database execution error, installation failed removing geodesic_addon_GeoModules_Paypal4Classifieds_site_orders.');
                        return false;
                } else {
                        //Normally, you do not need to give this much info, or any info at all, this is
                        //just used to demonstrate the use of the userNotice, userError, and userSuccess methods.
                        $admin_page_loader->userNotice('The table `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders` removed successfully.');
                }

    



                //Remove the cron task we added in the installation.
                //no cron task ever added so this isn't needed

                //If it made it all the way, then the installation was a success...
                //Note that displaying a message is not necessary, this is used to demonstrate success messages.
                $admin_page_loader->userSuccess('Addon un-install script completed.');
                return true;
        }

        function upgrade ($from_version = false)
        {
            ini_set('memory_limit', '512M');
            $db = true;
            $cron = true;
            include(GEO_BASE_DIR.'get_common_vars.php');
            
            if (PHP5_DIR) $admin_page_loader = Singleton::getInstance('geoAdmin');
            else $admin_page_loader =& Singleton::getInstance('geoAdmin');
            
            $previous_versions1 = array("1.0.3", "1.0.4", "1.0.5", "1.0.6", "1.0.7", "1.0.8", "1.0.9", "1.1.0", "1.1.1", "1.1.2", "1.1.3", "1.1.4", "1.1.5", "1.1.6", "1.1.7", "1.1.8", "1.1.9", "1.2.0",
                                    "1.2.1","1.2.2","1.2.3");
            $previous_versions2 = $previous_versions1;
            $previous_versions2[] =  "1.2.4";
            $previous_versions2[] =  "1.2.5";
            if (in_array($from_version, $previous_versions1) )
            {
                $test = 1;
                $sql = "ALTER TABLE `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders`
                    MODIFY `order_id` int(16) unsigned NOT NULL,
                    DROP PRIMARY KEY,
                    ADD (`listing_id` int(16) DEFAULT NULL)
                    ";
                $result = $db->Execute($sql);
                 if (!$result)
                {
                    //query failed, display message and return false.
                    $admin_page_loader->userError('Database execution error altering/adding fields in table `geodesic_addon_geomodules_paypal4classifieds_site_orders` , upgrade failed.');
                    return false;
                }
                $sql = "SELECT * FROM `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders`";                
                $current_orders = $db->GetArray($sql);
                if (is_array($current_orders))
                {
                    if(count($current_orders) > 0)
                    {
                        foreach ($current_orders as $value)
                        {
                            //$order =  geoOrder::getOrder($value['order_id']);
                            //$order_items_list = $order->getItem('classified');
                            $sql = "SELECT `parent`
                                    FROM `geodesic_order_item`
                                    WHERE `type` = 'pp4classified'
                                    AND `order` = '".$value['order_id']."'";
                            $listing_order_item_id = $db->GetOne($sql);
                            $sql = "SELECT `id` FROM `geodesic_classifieds` WHERE `order_item_id` = '".$listing_order_item_id  ."'";
                            $listing_id = $db->GetOne($sql);
                            //$listing_id = $order_item->get('listing_id');
                            if ($listing_id)
                            {
                                $listing = geoListing::getListing($listing_id, true, true);
                            }
                            
                            if ($listing)
                            {
                                $sql = "UPDATE `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders` SET `listing_id` = '".$listing_id."' WHERE `order_id` = '".$value['order_id']."'";
                                $result = $db->Execute($sql);
                                
                            }
                            else
                            {
                                
                                $sql = "DELETE FROM `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders` WHERE `order_id` = '".$value['order_id']."'";
                                $result = $db->Execute($sql);
                                //instead of deleting update with something indicating it is not there
                                 //$sql = "UPDATE `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders` SET `listing_id` = '999999' WHERE `order_id` = '".$value['order_id']."'";
                                //$result = $db->Execute($sql);                               
                            }
                            unset($order_items_list);
                            unset($order);
                            unset($sql);
                            unset($listing_id);
                            unset($listing);
                            
                                                        
                        }
                        
                    }
                }
                $sql = "ALTER TABLE `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders`
                        DROP `order_id`,
                        ADD PRIMARY KEY (`listing_id`)";
                $result = $db->Execute($sql);
                 if (!$result)
                {
                    //query failed, display message and return false.
                    $admin_page_loader->userError('Database execution error adding new key to `geodesic_addon_geomodules_paypal4classifieds_site_orders` , upgrade failed.');
                    return false;
                }                
                $task = 'GeoModules_Paypal4Classifieds:clean_removed_listings';     //The task name.  Must be ADDON_NAME:TASK where the TASK is the
                                                        //filename without the .php.  The task name cannot be more than
                                                        //128 chars.
                                                        
                $type = 'addon';     //2 types, addon or main.  Difference is that for addon type, the file is located
                                    //in addons/ADDON_NAME/cron/ directory, and main type is located 
                                    //in classes/cron/ directory.

                $interval = 86400;    //interval is in seconds, in this case we set it to 1 hour.
                                    //This is used when running the heartbeat cron, the
                                    //heartbeat will see which tasks have not been run in the amount of time specified
                                    //by the task's interval, and run the tasks that need to be run.
                                    //You can also force it to only be run if specifically
                                    //called in a manually set cron job, by setting the interval to -1.
                
                //now set the task, meaning we are adding it to the cron tasks that will be run.
                //Note that the task will only be run if        $task = 'geographic_navigation:geographic_navigation_task';     //The task name.  Must be ADDON_NAME:TASK where the TASK is the
                // the proper file exists, and the addon is enabled.
                //it is a good idea to also remove the task during the uninstall routine.
                $cron_add = $cron->set($task, $type, $interval);
                
                if (!$cron_add){
                    //failed to add task, display message and return false.
                    $admin_page_loader->userError('geoCron task failed to be added.');
                    return false;
                } else {
                    //let user know cron task addition was successful
                    $admin_page_loader->userNotice('geoCron task for addon was added.');
                }                
                
            }
            
            
            if (in_array($from_version, $previous_versions2) )
            {
                // go through each order item that has paypal in it and upgrade the session variables 
                $sql = "SELECT * FROM `geodesic_order_item` WHERE `type` = 'pp4classified' AND `status` = 'active'";
                $order_item_list = $db->GetArray($sql);
                
                foreach ($order_item_list as $key => $value)
                {
                    $pp_order_item = geoOrderItem::getOrderItem($value['id']);
                    $parent_order_item = $pp_order_item->getParent();
                    $sess_var = $parent_order_item->get(session_variables);


                    //test
                    $test = 1;
                    $sess_var['pp4classified'] = true;
                    $parent_order_item->set('session_variables', $sess_var);
                    $parent_order_item->save();
                    $test = 1;
                  

                    unset($sql);
                    unset($sess_var);
                    unset($pp_order_item);
                    unset($parent_order_item);

                }                  
                
            }
            
                        
          
            
            return true;
        }


}
