<?php
//addons/example/pages.php
# NOTE: If you are viewing the source, note that you can view phpdocs in the
# docs/ folder.
/**
 * Optional file, used to display an entire page.  Works kind of like
 * the tags, except that the tag being replaced is the main body tag.
 * 
 * Note that this version of the Example Addon is only compatible with
 * at least Geo 4.0, since stuff has changed since previous versions.
 * 
 * @package ExampleAddon
 * @since Geo Version 4.0.0
 */

/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2009 Geodesic Solutions, LLC
All rights reserved
http://www.geodesicsolutions.com
see license attached to distribution
**************************************************************************/

##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 16059              $ ##
## File last change date:       ##
##  $Date:: 2009-04-01 14:34:#$ ##
##                              ##
##################################

# Example Addon

# Note: PHPDocs can be found in docs/ folder.

/**
 * Addon page class, used by the addon system to display pages on the client side.
 * 
 * @package ExampleAddon
 * @since Geo Version 4.0.0
 */
class addon_GeoModules_Paypal4Classifieds_pages
{
	/**
	 * Works just like the tag functions.
	 * 
	 * @return string Text to replace the main body tag, if not specifying a template file.
	 */
	public function page1 ()
	{

		//2 ways to do things:
		//Method 1: Use smarty template (Recommended):
		//This method is ideal for replacing main body with a bunch
		//of text, and helps to keep business logic seperate
		//from view, yada yada...
		$session = geoSession::getInstance();
        //$testSite = new geoSite();
        //$testVar = $testSite->fields->getGroupId();
        $db = 1;
        $session = 1;
        require GEO_BASE_DIR . 'get_common_vars.php';
        $baseURL = str_replace  (  "index.php"  ,  ''  ,  $db->get_site_setting('classifieds_url') );  
        $view = geoView::getInstance();
        $settingsRegistry = geoAddon::getRegistry('GeoModules_Paypal4Classifieds');
        $textArray = geoAddon::getText('geo_modules', 'GeoModules_Paypal4Classifieds', $db->getLanguage);
        //$session->getStatus();
		//First, get instance of the view class
		$loginMsg = "you need to login";
		//get an instance of our info page, so we don't have stuff
		//hard coded in this file.
		$myInfo = Singleton::getInstance('addon_GeoModules_Paypal4Classifieds_info');
		
		//use the template file addons/example/templates/page1.tpl:
		$view->setBodyTpl('pages/page1.tpl',$myInfo->name);
		//$view->setHeaderTpl('header.tpl', $myInfo->name);
		//example of assigning a template variable that is local in scope to the template
		//file.  see that function for more details.
        $LID_SQL = "SELECT * FROM `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders`
                    WHERE `listing_id` = '".$_REQUEST['lid']."' ";
        $ppInfo = $db->GetRow($LID_SQL);		
        
        
        // check to make sure the visitor is logged in
        if ($session->getUserId() == 0)
        {
            // not logged in
            if ($_REQUEST['ppcount'] && $_REQUEST['lid'])
            // not logged in but might have timed out so check for ppcount
            // or might have never logged in but accepted the user agreement
            // in case pp link was clicked
            {
                $test = 1;
                
                if (count($ppInfo) > 0)// there is a record and ppcount
                {
                    // this is a click to go to the PayPal site. Need to deduct an amount.
                    $status = 4;
                }
                else
                {
                    // error not in db.
                    $status = 2;
                }                
            }
            else
            {
                // they never made it to view the PayPal inof screen. Check settings to see if login is required.
                if ($settingsRegistry->no_require_login == "true")
                {
                    $test = 1;
                    // check to see if user agreement is required
                    if ($settingsRegistry->require_user_agreement == "true")
                    {
                        // dealing with a user agreeement situation. 
                        // test if user agreement has been accepted
                        if ($_REQUEST['user_agreed'] == 'true')
                        {
                            // let them see the paypal information.
                            $status = 3;
                        }
                        else
                        {
                            // they have not agreed yet
                            // show the user agreement page
                            $status = 5;                            
                        }

                    }
                    else
                    {
                        // no user agreement required so just let them see the paypal info page
                        $status = 3;
                    }
                }
                else
                {
                    //login is required so set status to 0
                    $status = 0; 
                    
                }
                
            }
              
        }
        else // they are logged in so we check the lid
        {
            if ( $_REQUEST['lid'] ) //There was an LID passed
            {

                //test
                
                if (count($ppInfo) > 0)// there is a record
                {
                    if ($_REQUEST['ppcount'])
                    {
                        $status = 4;
                    }
                    else
                    {
                        $status = 3;
                    }

                }
                else
                {
                    $status = 2;
                }
                
                
            }
            else   // no lid was passed
            {
                $status = 1;
                
            }
        }
        
        
        
        switch ($status) 
        {
            case 0://not logged in
            $view->setBodyVar('ppmsg', $textArray['pp4classified_login_message']);
            break;
            
            case 1://logged in but no ;id
            $view->setBodyVar('ppmsg', 'This page was reached in a way which it was not intended.');
            break;
            
            case 2:// lid does not exist in the paypal table
            $view->setBodyVar('ppmsg', 'Error, not found in db');
            break;
            
            case 3:// lid exists, display normal body
            //$view->setBodyVar('ppmsg', 'The elements in the array count '.count($ppInfo));
            // get listing object
            $listing = geoListing::getListing($_REQUEST['lid']);            
            // conversion to tpl files
            $tpl = new geoTemplate(geoTemplate::ADDON, 'GeoModules_Paypal4Classifieds');
        $sqlItemCount = "SELECT `item_count`
                        FROM `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders`
                        WHERE `listing_id` = '".$_REQUEST['lid']."'";
        $itemCount = $db->GetOne($sqlItemCount);
        if ($itemCount < 1 || $listing->sold_displayed) // don't show if item count is not greater then 0
        {
            $tpl->assign('noitems_text1' , $textArray['noitems_text1']);
            $tpl->assign('noitems_text2' , $textArray['noitems_text2']);
            $tplBox = $tpl->fetch('pages/noitems.tpl');
           
            $view->setBodyVar('ppmsg', $tplBox);
            
            
            
            $view->setHeaderVar('refresh_rate', $settingsRegistry->refresh_rate);
            if (!$settingsRegistry->refresh_rate)
            {
                $view->addTop('<meta http-equiv="refresh" content="30">');
            }
            else
            {
                $view->addTop('<meta http-equiv="refresh" content="'.$settingsRegistry->refresh_rate.'">');
            }
            //echo "kkkk".$itemCount;
            $view->setBodyVar('ppmsg', $tplBox);             
            return;
        }        
        
            $tpl->assign('item_count' , $ppInfo['item_count'])  ;
            $tpl->assign('item_title' , geoString::fromDB($listing->title));
            $tplCostArray = array();
            

            $listingCategoryID = $listing->category; 
            $listingPricePlanID = $listing->price_plan_id;
            // get the plan item for the listing iteself
            $listingPlanItem = geoPlanItem::getPlanItem('classified', $listingPricePlanID ,$listingCategoryID );
            
            $sellerID = $listing->seller;
            
            $sqlSellerGroup = "SELECT `group_id`
                                FROM `geodesic_user_groups_price_plans`
                                WHERE `id` = '".$sellerID."'";
            $sellerGroup = $db->GetOne($sqlSellerGroup);
            $tpl->assign('sellerGroup' , $sellerGroup) ;
            // get all fields used to determine final price specific to the category with group_id as key
            $sqlCat = "SELECT *
                    FROM `geodesic_fields`
                    WHERE `field_type` = 'cost'
                    AND
                    `is_enabled` = '1'
                    AND
                    `category_id` = '".$listingCategoryID ."'
                    ORDER BY `field_name` DESC"  ;
                    
            
            $catPriceArray = $db->GetArray($sqlCat);
            if (count($catPriceArray) == '0') // if no resut this means there is no setting for this category, get default with group_id as key
            {
                    $sqlCat = "SELECT *
                    FROM `geodesic_fields`
                    WHERE `field_type` = 'cost'
                    AND
                    `is_enabled` = '1'
                    AND
                    `category_id` = '0'
                    ORDER BY `field_name` DESC"  ;
                    $catPriceArray = $db->GetArray($sqlCat); 
            }
            $catFieldArray = array($catPriceArray);
            $tpl->assign('catFieldArray' , $catPriceArray) ;
            //$view->setBodyVar( "catFieldArray", $catPriceArray ) ;
            $testArray = $catPriceArray[$sellerGroup];
            // go through the array to find out if any matches were found that used
            // the seller's group ID
            $groupFlag = false;
            foreach ($catPriceArray as $fieldset)
            {
                if ($fieldset['group_id'] == $sellerGroup)
                {
                    // we found a match, set the flag to true
                    $groupFlag = true;
                }
                
            }
            // if the flag is raised, remove results that don't match the group_id
            if($groupFlag)
            {
                foreach ($catPriceArray as $key => $fieldset)
                {
                    if ($fieldset['group_id'] != $sellerGroup)
                    {
                        // record group_id does not match, remove it
                        unset($catPriceArray[$key]);
                    }
                    
                }                 
                
            }
            else // no group flag... not group specific..use default group, remove results where group_is is not 0
            {
                foreach ($catPriceArray as $key => $fieldset)
                {
                    if ($fieldset['group_id'] != "0")
                    {
                        // record group_id does not match, remove it
                        unset($catPriceArray[$key]);
                    }
                    
                }
                
            }
            $tpl->assign('catFilteredFieldArray' , $catPriceArray) ;

            
            
            foreach ($catPriceArray as $costField) // go through the array and set the final cost
            {
                //$finalCost = $finalCost + $listing->__get($costField);
                //$finalCost .= $listing->__get($costField);
                $finalCost = $finalCost + $listing->$costField[field_name];
                //$finalCost .= $costField[field_name];
            }
            
            // get paypal address
            $sqlPaypal = "SELECT `paypal_address`
                        FROM `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders` 
                        WHERE `listing_id` ='".$_REQUEST['lid']."'";
            $paypalAddress = $db->GetOne($sqlPaypal);
            require_once GEO_BASE_DIR . "/addons/GeoModules_Paypal4Classifieds/paypal.inc.php";
            //to remove
            // form for how many items
            //$countForm = "<form>
            //                <p>You are ordering \"$listing->title\"</p>
            //                <p>additonal charges</p>";
            foreach ($catPriceArray as $costField)
            {
                if (stripos($costField['field_name'], 'ptional_field'))
                {
                    // to remove
                    //$countForm .= "<p>".$db->get_site_setting($costField[field_name].'_name') . "&nbsp;".$listing->$costField[field_name]. "</p>" ;
                    // tpl
                    $tplCostArray[] = array(name => $db->get_site_setting($costField[field_name].'_name'), cost => geoString::fromDB($listing->precurrency). geoNumber::format($listing->$costField[field_name])." ".geoString::fromDB($listing->postcurrency));
                    
                }

                if (stripos($costField['field_name'], 'rice'))
                {
                    //$countForm .= stripos($costField[field_name], 'ptional_field');
                    // to remove
                    //$countForm .= "<p>".$costField[field_name] ."&nbsp;".$listing->$costField[field_name].   "</p>";
                    //tpl
                    $tplCostArray[] = array(name => $textArray['pp4classified_price_label'], cost => geoString::fromDB($listing->precurrency) .geoNumber::format($listing->$costField[field_name])." ".geoString::fromDB($listing->postcurrency));
                }
                 
            }
            $totalCost = geoString::fromDB($listing->precurrency).geoNumber::format($finalCost)." ".geoString::fromDB($listing->postcurrency);
            //to remove
            //$countForm .= "</form>";
            // make the button
            $button = new PayPalButton;
            
            // example code altered
            $settingsRegistry = geoAddon::getRegistry('GeoModules_Paypal4Classifieds');
            
            $button = new PayPalButton;
            $button->return_url = $db->get_site_setting('classifieds_url')."?a=2&b=".$_REQUEST['lid'];
                                                                  //initiate the class instance
            $button->accountemail = $paypalAddress;                            //the account that is registered with paypal where money will be sent to
            $button->custom = '';                             //a custom string that gets passed through paypals pages, back to your IPN page and Return URL as $_POST['custom'] . useful for database id's or invoice numbers. WARNING: does have a max string limit, don't go over 150 chars to be safe
            if ($settingsRegistry->postcurrency_override != 'false')
            {
                $button->currencycode = $settingsRegistry->postcurrency_var;                
            }
            else
            {
                $button->currencycode = $listing->postcurrency;
                
            }
                                                                //currency code
            //$button->target = '_blank';                                                        //Frame Name, usually '_blank','_self','_top' . Comment out to use current frame.
            $button->class = 'paypalbutton';                                                //CSS class to apply to the button. Comes in very handy
            $button->width = '150';                                                            //button width in pixels. Will apply am Inline CSS Style to the button. Comment if not needed.
            //$button->image = $baseURL .'/images/jedi.jpg';                        //image 150px x 50px that can be displayed on your paypal pages.

            $button->buttonimage =  $baseURL.'addons/GeoModules_Paypal4Classifieds/images/btn_buynowCC_LG.gif';                                    //img to use for this button
            $button->buttontext = 'I agree, proceed to Payment';                            //text to use if image not found or not specified
            $button->askforaddress = true;                                                    //wether to ask for mailing address or not
            //$button->return_url = 'http://www.aussiehorsebrokers.com.au/paypal.php';        //url of the page users are sent to after successful payment

        //ITEMS
        //Paypal buttons are different when you're selling 1 item and anything more than 1 item. My class takes care of this for you.
        //Syntax: $button->AddItem(item_name,quantity,price,item_code,shipping,shipping2,handling,tax);
            $button->AddItem(geoString::fromDB($listing->title),'1',$finalCost,'Listing ID '.$_REQUEST['lid'],'','','','0.00');            
            $tpl->assign('button_code' , $button->OutputButton());
            
            
            
            
            $view->setHeaderVar('refresh_rate', $settingsRegistry->refresh_rate);
            if (!$settingsRegistry->refresh_rate)
            {
                $view->addTop('<meta http-equiv="refresh" content="30">');
            }
            else
            {
                $view->addTop('<meta http-equiv="refresh" content="'.$settingsRegistry->refresh_rate.'">');
            }            
            

            //$tpl->title = $textArray['pp4classified_label'];
            //$site = 
            //$tpl->help_link = geoTemplate::getUrl('',$this->messages[500797]);
            $tpl->assign('costArray' , $tplCostArray) ;
            $tpl->assign('totalCost' , $totalCost)  ;
            $tpl->assign('totalPriceLabel' , $textArray['pp4classified_total_label'])  ;
            $tplBox = $tpl->fetch('pages/confirm.tpl');
            
            
            
            
            
            
            
            
            
            
            
            //$view->setBodyVar('ppmsg', 'the array is <pre>'.print_r($catPriceArray).'</pre> The prics is '.$finalCost.'. The button code is '.$buttonCode. ' <pre>'.print_r($listing, true).'</pre>');
            $view->setBodyVar('ppmsg', $tplBox);                                                               
            break;
            
            
            
            case 4:  // this is the postback when a link to paypal is clicked that deducts from the paypal count
            $old_item_count =  (int)$ppInfo['item_count'];
            $item_count_deduction = (int)$_REQUEST['ppcount'];
            $new_item_count =  $old_item_count - $item_count_deduction;
            $sqlDeductItems = "UPDATE `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders`
                                SET `item_count` = '".$new_item_count."' 
                                WHERE `listing_id` = '".$_REQUEST['lid']."'";
            $db->Execute($sqlDeductItems);
            $updatecountbody = "<script type=\"text/javascript\">window.close()</script>";                     
            $view->setBodyVar('ppmsg', $updatecountbody.'hi, the old item count is'.$old_item_count."and minus $item_count_deduction the new is $new_item_count");
            
            break;
            
            case 5://not logged in and settings require user agreement
            $tpl = new geoTemplate(geoTemplate::ADDON, 'GeoModules_Paypal4Classifieds');
           
            
            $tpl->assign($textArray) ;

            $tplBox = $tpl->fetch('pages/user_agreement.tpl');            
            $view->setBodyVar('ppmsg', $tplBox);
            
            
            
            
            
            break;
        }
		
		
		//Method 2: just return the HTML text
		//See function tag_name2 for method 2
		
		//Note: you can actually do both, specify a template file and return text, in which
		//case the template will be included, and the returned text will be appended to the
		//end.
		
		return ;//'hello '. $_REQUEST['lll'] ." ". $session->getUserId()." ikk". $myInfo->name;
	}
	
	
}