<?php
//addons/example/order_items/eWidget.php
/**
 * Optional file.  System will parse the order_items/ directory, and use any
 * valid order item files found.  Your addon can create multiple order items.
 * 
 * Note that any file found in the order_items/ directory that starts with an
 * underscore _ will be ignored by the system.
 * 
 * This example order item is configured to work for a specific purpose (so there
 * is a "working" example order item for you to "start" from), it does not
 * document everything that order items can do.  To see the full
 * order item documentation, see the "template" order item found in the main
 * software at:
 * 
 * classes/order_items/_template.php
 * 
 * See that file for further documentation.
 * 
 * @author Geodesic Solutions, LLC
 * @package ExampleAddon
 * @since Version 4.0.0
 */

/**************************************************************************
Addon Created by Geodesic Solutions, LLC
Copyright (c) 2001-2009 Geodesic Solutions, LLC
All rights reserved
http://www.geodesicsolutions.com
see license attached to distribution
**************************************************************************/
##########SVN Build Data##########
##                              ##
## This File's Revision:        ##
##  $Rev:: 16874              $ ##
## File last change date:       ##
##  $Date:: 2009-06-28 17:43:#$ ##
##                              ##
##################################

# Example Addon

/**
 * This order item is designed to allow users on your site to purchase an 
 * eWidget.
 * 
 * This order item does everything you might think a widget order item might
 * do:
 * 
 * - set the cost in the admin, under price plan cost specifics, under the plan
 *   item settings
 * - user can add widget to their cart by clicking on "add widget" button -
 *   button is displayed automatically in main cart view, and also in the
 *   "listing cart" "add item" section of the my account links module.
 * - This item has a 2 page process for adding a widget to the cart.  Since
 *   this is just an example, the pages don't do much, they just demonstrate
 *   how to set up different steps for adding an item to the cart.
 * - Allows user to preview the widget.  (all preview does is display an image,
 *   since this is an example)
 * - All the built-in processes for order items will work, such as viewing
 *   pending widgets, the system auto-activating widget once it's paid for,
 *   if admin checks "needs admin approval" the widget does NOT auto activate,
 *   etc.
 *   
 * Since this "Widget" addon is designed to work as specified above, it will
 * not demonstrate or document everything order items can actually do.  For
 * that, look at the template order item found in the main software at:
 * 
 * classes/order_items/_template.php
 * 
 * Use the file above as a starting point for creating your own order item if
 * you are creating one that differs drastically from what this widget does.
 * 
 * You can create as many order items inside of an addon, by creating an
 * order_items/ directory, and placing your order items in that directory.
 * 
 * This example Widget order item demonstrates a "parent" order item, or an
 * order item that has no "parents" of it's own, so it will be added directly
 * to an order.  A parent order item will not be attached to another order item.
 * 
 * Other "parent" order items used in the main software:  auction, classified,
 * listing renew/upgrade, listing edit, subscription renewal
 * 
 * A "child" order item is one that is attached to a parent order item.  Parent
 * order items don't have to have children, but children DO have to have a
 * parent.  Examples of "child" order items are: bolding extra, better placement
 * extra, featured listing extra (levels 1-5), account tokens attached, and 
 * listing images.
 * 
 * Note that the class name should match the file name.  The syntax for the
 * order item class name is:
 * 
 * [File Name]OrderItem
 * 
 * The class name does not include the ending ".php" of course.  And it is case
 * sensitive.
 * 
 * @package ExampleAddon
 */
class pp4classifiedOrderItem extends geoOrderItem
{
    protected $type = "pp4classified";
    const type = 'pp4classified';
    protected $defaultProcessOrder = 35;
    const defaultProcessOrder = 35;
    const addonName = 'GeoModules_Paypal4Classifieds';
    
    public function adminPlanItemConfigDisplay ($planItem)
    {   
    
    
        //return "<pre>". $planItem->getPricePlan()."</pre>";    
        $db = 1;
        require GEO_BASE_DIR . 'get_common_vars.php';
        $pricePlanSQL = "SELECT `applies_to` FROM `geodesic_classifieds_price_plans`
                        WHERE `price_plan_id` = '".$planItem->getPricePlan()."'";
        $applies_to = $db->GetOne($pricePlanSQL);
        
        if ($applies_to == 2)
        {
            return "This is not used with Auctions";
        }
        
        //getting my own PlanItem since geo always passes in one for the root category -Brent
        $myPlanItem = geoPlanItem::getPlanItem('pp4classified',$_REQUEST['price_plan_id'],$_REQUEST['category_id'], true );
        $myPlanItem2 = geoPlanItem::getPlanItem('pp4classified',$_REQUEST['price_plan_id'],$_REQUEST['category_id']);
        $tpl = new geoTemplate(geoTemplate::ADDON, self::addonName);
        
        $tpl->assign('enabled' , $myPlanItem->getEnabled()) ;
        // adds price option outside of the smarty template
        // if this addon gets attention I might convert this to smarty -Brent
        $html = $tpl->fetch('admin/planItem.tpl');
        // need to format this number according to site currency settings -Brent
        $currentPrice = geoNumber::format($myPlanItem->get('price',0.00)); 
        $txt = '<div>';
        $inputField = $db->get_site_setting('precurrency');
        //Note: for settings, it works best to use an array with the name
        //the same as the order item name
        $inputField .= "<input type='text' name='GeoModules_Paypal4Classifieds[price]' id='GeoModules_Paypal4Classifieds[price]'
            size='4' value='$currentPrice' />";
        $inputField .= $db->get_site_setting('postcurrency');
        $txt .= geoHTML::addOption('Cost for adding a paypal button',$inputField);
        /*$txt .= "<br/>This is the category ID for the planitem". $planItem->getCategory().
        "<br/><br/>this is the category ID you are really in ".
        "<br/><br/> This is the contents of planItem <br/><br/><pre>".print_r($planItem,true)."</pre>"
        ."<br/><br/> This is the contents of myPlanItem <br/><br/><pre>".print_r($myPlanItem,true)."</pre>"
        ."<br/><br/> This is the contents of myPlanItem2 <br/><br/><pre>".print_r($myPlanItem2,true)."</pre>" 
         ;*/      
         $txt .= "</div>";
         return $html.$txt;


    }
    
    /**
     * Optional.
     * Used: In admin, during ajax call to update config settings for a particular
     * price plan item.
     * 
     * This is only used if adminPlanItemConfigDisplay() is used.
     *
     * @param geoPlanItem $planItem
     * @return bool If return true, message "settings saved" will be displayed, if return
     *  false, message "settings not saved" will be displayed.
     */
     
    public function adminPlanItemConfigUpdate ($planItem)
    {
        
        //getting my own PlanItem since geo always passes in one for the root category -Brent

        $myPlanItem = geoPlanItem::getPlanItem('pp4classified',$_REQUEST['price_plan_id'],$_REQUEST['category_id'], true );
        
        
        
        $settings = $_POST['GeoModules_Paypal4Classifieds'];
        
        if(!isset($settings['dummy'])) 
        {
            //something wrong, data not submitted?
            return false;
        }
        $enabled = (isset($settings['enabled']) && $settings['enabled'])? 1: 0;
        
        $price = geoNumber::deformat($settings['price']);
        $myPlanItem->set('price',$settings['price']);
        $myPlanItem->setEnabled($enabled);
        $myPlanItem->save();
        //Note that usually when setting something on a planItem, you will
        //need to save the plan item, but in this case that is done
        //automatically by the system after this function is done.
        return true;
    }
    
    /**
     * Optional.
     * Used: in geoCart::other_detailsDisplay()
     * 
     * Used by items that are displayed & processed at the built-in other details step.
     * This will be called during other_details step, if that step is displayed, for
     * all items and children items, even if there are none of this type of item in
     * the cart yet.
     * 
     * TODO: document this function further - needs to return an associative array like any of the listing extras do
     * 
     *
     */
         
    public static function geoCart_other_detailsDisplay ($vars)
    // this adds a item in the checkout process
    // under the "extras" step
    {
        $statusRenewUpgrade = ""; //variable I will use to for tracking renew and upgrade processe
        $db = 1;
        require GEO_BASE_DIR . 'get_common_vars.php';
        
        $cart = geoCart::getInstance();
        $textArray = geoAddon::getText('geo_modules', 'GeoModules_Paypal4Classifieds', $db->getLanguage);
        
        // checks to make sure type is in the allowed/listed in the getParentTypes() function 
        // not sure what this checks so I have it disabled atm -brent
        if (!($cart->main_type == self::type || in_array ($cart->main_type,geoOrderItem::getParentTypesFor(self::type) ) ) ) 
        {
            //do not show option because it is not in the allowed list
            return '';
        }
        if (isset($cart->item->renew_upgrade) && $cart->item->renew_upgrade > 0 && $cart->item->renew_upgrade == listing_renew_upgradeOrderItem::upgrade)
        {
            $test = 1;
            //this is an upgrade, need to see if parent already has item
            if ($cart->site->parent_session_variables['pp4classified'])
            {
                //already exists on parent, do not allow adding
                return '';
            }
        }        
        if (isset($cart->item->renew_upgrade) && $cart->item->renew_upgrade == 0) // not a renewal or upgrade (not sure why isset must be used because renew_upgrade seems to always be used)
        {
            $statusRenewUpgrade .= "<br/><b><big>Initial checks indicate this is not a renewal or an upgrade</big></b><br/>";
            $statusRenewUpgrade .= $cart->item->getType(); 
        }
        if (isset($cart->item->renew_upgrade) && $cart->item->renew_upgrade != 0 ) // this appears to be a renewal or upgrade
        {
            // need to check to make sure this is renewing a classified, if not do nothing and return
            if ($cart->item->get('item_type') != "1")
            {
                return;
            }
            $listing = geoListing::getListing($cart->item->get(listing_id));
            $parentOrderID = $listing->order_item_id;
            $parentOrderItem = geoOrderItem::getOrderItem($parentOrderID);
            if ($parentOrderItem)
            $parentOrder = $parentOrderItem->getOrder();
            $statusRenewUpgrade .= $cart->item->getType();  
            
            
            
            
            $statusRenewUpgrade .= "<br/><b><big>This is either a renew or upgrade with the values of ".$cart->item->renew_upgrade."<               /big></b><br/>";
            $statusRenewUpgrade .= "<br/> The parents orderitem <br/><br/><pre>".print_r($parentOrderItem, true)."</pre><br/>";
            //$statusRenewUpgrade .= "<br/> The original order ID is ".$parentOrderItem['order']. " next line";
            $statusRenewUpgrade .= "<br/><b><big>The parent order:<br/><br/></big></b><pre>";
            $statusRenewUpgrade .= print_r($parentOrder, true)."</pre><br/><br/>";
            //return ''; // temp keep editing from showing up in rewews or upgrades 
        }
        
        // checks if this is a renew or upgrade order and if so, if the option should be displayed
        // temp not used
        /*
        if (isset($cart->item->renew_upgrade) && $cart->item->renew_upgrade == listing_renew_upgradeOrderItem::upgrade)// listing_renew_upgradeOrderItem::upgrade is a constant (2)
        {
            //this is an upgrade, need to see if parent already has item
            $statusRenewUpgrade .= "<br/><b><big>This is an upgrade order</big></b><br/>";
            $statusRenewUpgrade .= "<br/>parent session<br/><pre>".print_r($cart->site->parent_session_variables, true)."</pre><br/>";
            

            if ($cart->site->parent_session_variables['pp4classified'])
            {
                //already exists on parent, do not allow adding
                return '';
            }
            $displayArray =  array (
                'checkbox_name' => 'ppcheckbox', //manually created checkbox
                'title' =>  "dfs",
                'help_id' => 0,//manually created
                'price_display' => $formatedPrice,
                //templates - over-write mini-template to do things like set margine or something:
                'entire_box' => $tplBox  
            );
            return   $displayArray;
        }
        */
        // I don't get this
        if ($cart->item->getType() == self::type)
        {
            $item = $cart->item->getParent();
        } 
        else 
        {
            $item = $cart->item;
        }
        
        
        // not sure what this does exactly
        $cart->setPricePlan($item->getPricePlan(),$item->getCategory());
        $helpText = "help text";
        // start of code I'm trying to make myself
        $help_link =  "<a href=\"javascript:win('show_help.php?addon=GeoModules_Paypal4Classifieds&amp;auth=geo_modules&amp;textName=pp4classified_desc');\"><img src=\"".urldecode($db->get_site_setting('help_icon'))."\" alt=\"\" /></a>";
        
        $planItem1 = geoPlanItem::getPlanItem('pp4classified',$cart->item->getPricePlan(),$cart->item->getCategory(), true);
        $planItem2 = geoPlanItem::getPlanItem('pp4classified',$cart->item->getPricePlan(),$cart->item->getCategory());
        //if ($planItem2)                                  
        //$myPlanItem = geoPlanItem::getPlanItem('pp4classified',$cart->item->getPricePlan(),$cart->item->getCategory(), true);

        $myPlanItem = pp4classifiedOrderItem::getMyPlanItem($cart->item->getPricePlan(), $cart->item->getCategory());
        
        if (!$myPlanItem->getEnabled())
        {
            // not enabled, return noting
            return;
        }
        // need to format this number according to site currency settings -Brent
        $currentPrice = geoNumber::format($myPlanItem->get('price',0.00));
        $formatedPrice = $db->get_site_setting('precurrency'). " ". $currentPrice. " ". $db->get_site_setting('postcurrency');                 
        //$itemTitle = 
        
        
        
        
        $display_checkbox_name = $textArray['pp4classified_label'];
        if ($cart->item->getType() != "listing_edit")
        {
            $itemExists = $cart->order->getItem('pp4classified'); 
            $tpl = new geoTemplate(geoTemplate::ADDON, self::addonName);
            if(isset($_POST['c']['pp4classifiedemail']))
            {
                $pp4classifiedemail = $_POST['c']['pp4classifiedemail'];
                $pp4classifiedcount = $_POST['c']['pp4classifiedcount'];
                $pp4classifiedchecked = $_POST['c']['pp4classified']; 
            }
            else
            {
                $sqlIsThere = "SELECT * FROM `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders`
                                WHERE `listing_id` = \"".$listing->id."\"";
                
                $isThere = $db->GetArray($sqlIsThere);
                if ($isThere)
                {
                    $pp4classifiedemail = $isThere['0']['paypal_address'];
                    $pp4classifiedcount = $isThere['0']['item_count'];
                    $pp4classifiedchecked = "1";                    
                }                
                
                
            }
            $tpl->assign('price' , $formatedPrice)  ;
            $tpl->assign('title' , $textArray['pp4classified_label'])  ;
            $tpl->assign('pp4classified_email_address_label' , $textArray['pp4classified_email_address_label']) ; 
            $tpl->assign('pp4classified_multi_item_label' , $textArray['pp4classified_multi_item_label'])   ;
            $tpl->assign('pp4classifiedemail' , $pp4classifiedemail)  ;
            $tpl->assign('pp4classifiedcount' , $pp4classifiedcount);
            $tpl->assign('pp4classifiedchecked' , $pp4classifiedchecked)  ;
            //$site = 
            //$tpl->help_link = geoTemplate::getUrl('',$this->messages[500797]);
            $tplBox = $tpl->fetch('cart/ListingExtraItem.tpl');
            
            $display_entire_box .= "<br/><br/><pre>".print_r($itemExists, true)."</pre><br/><br/>";        
            $parentsbox = $cart->main_type;
            
            $displayArray =  array (
                'checkbox_name' => 'ppcheckbox', //manually created checkbox
                'title' =>  $display_checkbox_name."jgg",
                'help_id' => 0,//manually created
                'price_display' => $formatedPrice,
                //templates - over-write mini-template to do things like set margine or something:
                'entire_box' => $tplBox

                        

                        //. print_r($exists, true)    
                        //.$cart->item->renew_upgrade
                        
                //'left' => "<div class='ad_cost_features_field_labels checkbox_options' style='margin-left: 5px;'>
                //                (!TITLE!)
                //                <div class='listing_help'>
                //                    (!DISPLAY_HELP_LINK!)
                //                </div>
                //            </div>",
                //'right' => "
                //            <div class='listing_price ad_cost_features_data_values' style='text-align: right;'>
                //                (!PRICE_DISPLAY!)
                //            </div>
                //            <div class='clear'></div>",
                //'checkbox' => 'checkbox tag'
                //'checkbox_hidden' => 'hidden input tag'     
            );
            
            
            
            
            
            
            
             
            
            
            
            
            $additionalText = "<br/><br/><br/> is it enabled <br/><br/><br/>"
                        .//print_r($Item->getPlanItem(), true).
                        $myPlanItem->getEnabled().
                        "<br/><br/><br/>myplanitem<br/><br/><br/><pre>".
                        print_r($myPlanItem, true).
                        
                        
                        "</pre><br><br/><br/> the price  I am manually pulling with my own code<br/><br/><br/>".
                        $myPlanItem->get('price'). "  <br/>Formated<br/> ".$currentPrice. 
                        "<br/><br/>the category you are in per the cart <br/><br/>".$cart->item->getCategory().
                        
                        "<br/><br/>the category you are in per myPlanITem <br/><br/>".$myPlanItem->getCategory().
                        "<br/><br/>the priceplan you are in per the cart <br/><br/>".$cart->item->getPricePlan().
                        "<br><br/><br/> the actual result of item from the statemnt <br/><br/><br/><pre>".
                        print_r($item, true).
                        "</pre><br/><br/>the rusult of cart - > item<br/><br/><pre>".
                        print_r($cart->item, true).
                        "</pre><br/><br/>This is the price plan<br/><br/><pre>".
                         print_r($cart->price_plan, true).
                        "</pre><br/><br/> if the plan item is enabled <br/><br/><pre>"
                        .$myPlanItem->getEnabled().
                        "</pre><br/><br/> sql array <br/><br/><pre>"
                        .print_r(pp4classifiedOrderItem::getMyPlanItem($cart->item->getPricePlan(), $cart->item->getCategory() ), true).
                        "</pre>"
                        ;
                        
            $cartItemOnly = "<br/><br/><pre>" . print_r($cart->item, true).   " </pre><br/><br/>";
                        if ($cart->getChildItem('pp4classified'))
                        {
                            $ppOrderItem = $cart->getChildItem('pp4classified');
                            $ppId =  $ppOrderItem->getId();
                            //$cart->item->remove($ppId);
                            
                        }
                        

                        
            
                        
                        
                        
                        
            return   $displayArray;
        }
        
        else //this is a edit listing step, handle differently
        {
            $listing_id = $cart->item->get('listing_id');
            /*
            $SQLorignalOrder = 'SELECT  `order_item`
                                FROM 
                                `geodesic_order_item_registry`
                                WHERE `index_key` = "listing_id"
                                AND
                                `val_string` = "'.$cart->item->get('listing_id') .'"
                                ORDER BY `order_item` LIMIT 1';
            $originalOrderIdResult = $db->GetArray($SQLorignalOrder);
            $originalOrderId = $originalOrderIdResult[0][order_item];
            
            $SQLorignalOrderItem = 'SELECT `order` FROM `geodesic_order_item` 
                                    WHERE `parent` = "'.$originalOrderId.'"
                                    AND
                                    `type` = "pp4classified"';
            $originalOrderItemId = $db->GetOne($SQLorignalOrderItem);
            */
            
            
            $sqlIsThere = "SELECT * FROM `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders`
                            WHERE `listing_id` = \"".$listing_id."\"";
            
            $isThere = $db->GetArray($sqlIsThere);
            $display_checkbox_name = $textArray['pp4classified_label'];
            $present = $cart->site->session_variables['pp4classified'];
            $test = 1;
            if ($present)
            {
                $tpl = new geoTemplate(geoTemplate::ADDON, self::addonName);
                //$tpl->price = $formatedPrice;
                $tpl->assign('title' , $textArray['pp4classified_label']) ;
                //$site = 
                //$tpl->help_link = geoTemplate::getUrl('',$this->messages[500797]);
                if ($_POST['c']['pp4classifiedemail'])
                {
                    $tpl->assign('pp4classifiedemail' , $_POST['c']['pp4classifiedemail']) ;
                    $tpl->assign('pp4classifiedcount' , $_POST['c']['pp4classifiedcount']) ;                    
                }
                else
                {
                    $tpl->assign('pp4classifiedemail' , $isThere['0']['paypal_address'])  ;
                    $tpl->assign('pp4classifiedcount' , $isThere['0']['item_count']) ;                    
                }

                $tpl->assign('pp4classified_email_address_label' , $textArray['pp4classified_email_address_label']) ;
                $tpl->assign('pp4classified_multi_item_label' , $textArray['pp4classified_multi_item_label'])  ;

                $tplBox = $tpl->fetch('cart/ListingExtraItemEdit.tpl');
                $itemExists = $cart->order->getItem('pp4classified');
                $display_entire_box .= "<br/><br/><pre>".print_r($itemExists, true)."</pre><br/><br/>";        
                $parentsbox = $cart->main_type;
                $displayArray =  array (
                    'checkbox_name' => 'ppcheckbox', //manually created checkbox
                    'title' =>  $display_checkbox_name,
                    'help_id' => 0,//manually created
                    //templates - over-write mini-template to do things like set margine or something:
                    'entire_box' => $tplBox
                    );                   
            }
            else
            {
 
                $tpl = new geoTemplate(geoTemplate::ADDON, self::addonName);
                $tplBox = $tpl->fetch('cart/ListingExtraItemNone.tpl');
                $tpl->assign('pp4classified_email_address_label' , $textArray['pp4classified_email_address_label']) ;
                $tpl->assign('pp4classified_multi_item_label' , $textArray['pp4classified_multi_item_label']) ;
                $displayArray =  array (
                    'checkbox_name' => 'ppcheckbox', //manually created checkbox
                    'title' =>  $display_checkbox_name,
                    'help_id' => 0,//manually created
                    //templates - over-write mini-template to do things like set margine or something:
                    'entire_box' => $tplBox
                    );
                
            }

                
 
            return   $displayArray;
        }
        
        /* array (
            'checkbox_name' => 'ppcheckbox', //manually created checkbox
            'title' => 'Paypal for your classified',
            'help_id' => 0,//manually created
            'price_display' => '',
            //templates - over-write mini-template to do things like set margine or something:
            'entire_box' => "
                    This is the full cart when if I am displaying it<br/><br/>".
                    //"<pre>". print_r($cart, true)."</pre><br/><br/>".
                    "<div class='clear'></div>
                    <div class='transation_listing_box container_width box_options' style='height:auto;'>
                        <div class ='ad_cost_features_field_labels checkbox_options' style='margin-top:10px;'>
                            <input name='c[pp4classified]' value='1' type='checkbox'  />".$textArray['pp4classified_label']."
                          $help_link  
                        </div>
                        <div class='listing_price ad_cost_features_data_values'>
                            $formatedPrice
                        </div>
                        <div class='clear'></div>
                        <div class='personal_info_data_values'>
                            Paypal Email Address : <input name='c[pp4classifiedemail]' value='' type='text'  />".//$cart->getErrorMsg(ppEmailInvalid).//$textArray['pp4classified_email_label']
                            "&nbsp; Number of Items : <input name='c[pp4classifiedcount]' value='' type='text'  />
                        </div>
                    </div>"
                    .$statusRenewUpgrade."<br/><br/>"
                    .$cartItemOnly
                    
                    .$additionalText
                    //. print_r($exists, true)    
                    //.$cart->item->renew_upgrade
                    ,
            //'left' => "<div class='ad_cost_features_field_labels checkbox_options' style='margin-left: 5px;'>
            //                (!TITLE!)
            //                <div class='listing_help'>
            //                    (!DISPLAY_HELP_LINK!)
            //                </div>
            //            </div>",
            //'right' => "
            //            <div class='listing_price ad_cost_features_data_values' style='text-align: right;'>
            //                (!PRICE_DISPLAY!)
            //            </div>
            //            <div class='clear'></div>",
            //'checkbox' => 'checkbox tag',
            //'checkbox_hidden' => 'hidden input tag'     
        );
        
        return $return;        
        
        */
        
    }
    
    
    
    /**
     * Optional.
     * Used: in geoCart::other_detailsCheckVars()
     * 
     * Used by items that are displayed & processed at the built-in other details step, or 
     * items that may have children at this step.  If a problem with input vars is found,
     * or it should not proceed to next step for whatever reason, use geoCart::addError()
     * to let the system know there is a problem.
     * 
     * Note that this is called for all order items, so need to check to see if main type
     * warrents it checking vars first.
     * 
     * This can be used as a template for other checkVars functions for specific not-built-in steps
     *
     */
    public static function geoCart_other_detailsCheckVars ($vars)
    {
        //TODO: implement or remove...

        $cart = geoCart::getInstance();
        //do checking of vars here
        //$cart->item->parent::_getSessionVarsFromListing($cart->item->get('listing_id'), true, true);
// test       
        $parents = (is_callable(array('geoOrderItem','getParentTypesFor')))? geoOrderItem::getParentTypesFor(self::type) : self::getParentTypes();
        if (!($cart->main_type == self::type || in_array ($cart->main_type,$parents)))
        {
            //do not run anything
            return ;
        }        
        
        if (isset($_POST['c']))
        {
            if ($cart->item->getType() == self::type)
            {
                $item = $cart->item->getParent();
            } 
            else 
            {
                $item = $cart->item;
            }
        }
        else
        {
            $item = $cart->item;
        }        
        $cart->setPricePlan($item->getPricePlan(),$item->getCategory());
        
        
        
// end test        
        if ($_POST['c']['pp4classified'])  // if the checkbox is checked for wanting the button
        {
            // brent's bool to determine adding to the cart
            $addStatus = true;
            
            $ppEmail = $_POST['c']['pp4classifiedemail'];
            if ($cart->main_type != self::type && !in_array($cart->main_type, geoOrderItem::getParentTypesFor(self::type)))
            {
                //item being added does not have anything to do with this item, so no need to check vars.
                $addStatus = false;
                return;
            }
            if ($check)
            {
                //dummy check, to demonstrate how to tell the cart there is a problem and to not proceed to next step yet.
                $cart->addError();
            }
            
            if (!geoString::isEmail($ppEmail) )
            {
                $addStatus = false;
                $cart->addError();
                $cart->addErrorMsg('ppEmailInvalid', 'Your Paypal email address does not appear to be a valid email address.');
            }
            
            if ( !(preg_match( '/^\d*$/'  , $_POST['c']['pp4classifiedcount']) == 1) )
            {
                $addStatus = false;
                $cart->addError();
                $cart->addErrorMsg('ppCountInvalid', 'The entry for the number of items you are listing via the PayPal payment feature needs to be a valid and/or whole number.');                
            }
            if ($_POST['c']['pp4classifiedcount'] < '1') 
            {
                $addStatus = false;
                $cart->addError();
                $cart->addErrorMsg('ppCountInvalid', 'The entry for the number of items you are listing via the PayPal payment feature needs to be greater than zero..');                
            }            
            // now that all the error checking has been done
            $test = 1;
            if ($addStatus && $_POST['c']['pp4classified'])
            {
                $cart->site->session_variables['pp4classified'] = true;
                $cart = geoCart::getInstance();
                
                $pp_array = $cart->item->get('pp_array');
                if (!is_array($pp_array[$cart->item->getId()]))
                {
                    $this_array = array('email' => $_POST['c']['pp4classifiedemail'], 'count' => $_POST['c']['pp4classifiedcount']);
                    $pp_array[$cart->item->getId()] = $this_array;
                    /* changing to work on $item instead of $cart->item
                    $cart->item->set('pp_array', $pp_array);
                    $cart->item->set('session_variables',$cart->site->session_variables);
       
                    $cart->item->save();
                    */
                    $item->set('pp_array', $pp_array);
                    $item->set('session_variables',$cart->site->session_variables);
       
                    $item->save();                    
                    
                    $myPlanItem = pp4classifiedOrderItem::getMyPlanItem($cart->item->getPricePlan(), $cart->item->getCategory());
                     // old
                    $currentPrice = geoNumber::format($myPlanItem->get('price',0.00));
                    //$currentPrice = $cart->price_plan['attention_getter_price'];
                    //129-135 in addon_attention getter, inside if statement
                    
                    $order_item = new pp4classifiedOrderItem;
                    $order_item->setParent($cart->item);//this is a child of the parent
                    $order_item->setOrder($cart->order);
                    //test manually setting the category so it adds a different price -Brent
                    // cost added after saving in attention getter example
                    //$order_item->setCost($currentPrice);
                    $already_attached = false;
                    // created added after saving in attention getter example
                    //$order_item->setCreated($cart->order->getCreated()); 
                    $order_item->save();//make sure it's serialized
                    $cart->order->addItem($order_item);                    
                    
                    $order_item->setCost($currentPrice);
                    $order_item->setCreated($cart->order->getCreated());
                }    

            }   
            
            
            
        }
        else
        {
            // may need to make sure that session vars and order items are removed
            
            
        }

        
        /*
        $myPlanItem = geoPlanItem::getPlanItem('pp4classified',$cart->item->getPricePlan(),$cart->item->getCategory());
        $currentPrice = geoNumber::format($myPlanItem->get('price',0.00));
        
        //129-135 in addon_attention getter, inside if statement
        $order_item = new pp4classifiedOrderItem;
        $order_item->setParent($cart->item);//this is a child of the parent
        $order_item->setOrder($cart->order);
        
        $already_attached = false;
        $order_item->save();//make sure it's serialized
        $cart->order->addItem($order_item);
        

        //get the price for attention_getter
        $cost =  $currentPrice;
        //($cart->db->get_site_setting('all_ads_are_free'))? 0:$cart->price_plan['attention_getter_price'];
        $order_item->setCost($cost);
        $order_item->setCreated($cart->order->getCreated());        
        */
        
        //make sure to call check vars for children as well.
        $children = geoOrderItem::getChildrenTypes('_template');
        geoOrderItem::callUpdate('geoCart_other_detailsCheckVars',null,$children);
    }
    
    
    
    
    
    /**
     * Optional.
     * Used: in geoCart::other_detailsProcess()
     * 
     * Used by items that are displayed & processed at the built-in other details step, or 
     * items that may have children at this step.  Things like adding or removing an item
     * based on a checkbox selection should be done here.
     * 
     * Note that this is called for all order items, so need to check to see if main type
     * warrents it processing for that main type first.
     * 
     * This can be used as a template for other Process functions for specific not-built-in steps
     *
     */
    public static function geoCart_other_detailsProcess ()
    {
        //pp4classifiedOrderItem::brentsRealProcess();

        
        //get steps from children as well.
        $children = geoOrderItem::getChildrenTypes(self::type);
        geoOrderItem::callUpdate('geoCart_other_detailsProcess',null,$children);
        
    }
    
    
    
    public static function brentsRealProcess()
    {
        
        
        
        
        $db = 1;
        require GEO_BASE_DIR . 'get_common_vars.php';
        
        //TODO: implement or remove...
        $cart = geoCart::getInstance(); //get instance of cart
        
        if 
        (
        $cart->main_type != self::type && 
        !in_array($cart->main_type, geoOrderItem::getParentTypesFor(self::type))
        )
        {
            //item being added does not have anything to do with this item, so no need to do anything.
            return;
        }
        //Error checking should have been done in checkVars, if there were any errors this function
        //would not be run, so do not need to do error checking here.
        
        //Do any processing, like adding child item to order based on selection.
        
        // determining if the order already has a pp4classified orderItem
        
        
        $itemExists = $cart->order->getItem('pp4classified');
        if (!is_array($itemExists)) // always runs
        {
        
        
                
        //this is where I'm transplanting from the checkvars step
        
        
        
        if (isset($_POST['c']['pp4classified']))
        {
            
        
            //$myPlanItem = geoPlanItem::getPlanItem('pp4classified',$cart->item->getPricePlan(),$cart->item->getCategory(), true);
            $myPlanItem = pp4classifiedOrderItem::getMyPlanItem($cart->item->getPricePlan(), $cart->item->getCategory());

            $currentPrice = geoNumber::format($myPlanItem->get('price',0.00));
            
            //129-135 in addon_attention getter, inside if statement
            
            $order_item = new pp4classifiedOrderItem;
            $order_item->setParent($cart->item);//this is a child of the parent
            $order_item->setOrder($cart->order);
            //test manually setting the category so it adds a different price -Brent
            $order_item->setCost($currentPrice);
            $already_attached = false;
            $order_item->setCreated($cart->order->getCreated()); 
            $order_item->save();//make sure it's serialized
            $cart->order->addItem($order_item);
            

            //get the price for attention_getter
            //$cost =  $cart->item->getCategory().'.34';
            //($cart->db->get_site_setting('all_ads_are_free'))? 0:$cart->price_plan['attention_getter_price'];
            //$order_item->setCost($cost);
        
            $order_Id = $cart->order->getId();
            $ppEmail = $_POST['c']['pp4classifiedemail'];
            $ppCount = $_POST['c']['pp4classifiedcount'];
            $insert = "INSERT INTO `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders` 
            (`order_id`, `item_count`, `paypal_address`) 
            VALUES ($order_Id, $ppCount, '$ppEmail')";
            $db->Execute($insert);
        }
        }        
        
        
        
    }    
    
    
    
    public static function brentsRealProcessbackupcopy()
    {
        
        
        
        
        $db = 1;
        require GEO_BASE_DIR . 'get_common_vars.php';
        
        //TODO: implement or remove...
        $cart = geoCart::getInstance(); //get instance of cart
        
        if 
        (
        $cart->main_type != self::type && 
        !in_array($cart->main_type, geoOrderItem::getParentTypesFor(self::type))
        )
        {
            //item being added does not have anything to do with this item, so no need to do anything.
            return;
        }
        //Error checking should have been done in checkVars, if there were any errors this function
        //would not be run, so do not need to do error checking here.
        
        //Do any processing, like adding child item to order based on selection.
        
        
        //this is where I'm transplanting from the checkvars step
        if (isset($_POST['c']['pp4classified']))
        {
        
            //$myPlanItem = geoPlanItem::getPlanItem('pp4classified',$cart->item->getPricePlan(),$cart->item->getCategory(), true);
            $myPlanItem = pp4classifiedOrderItem::getMyPlanItem($cart->item->getPricePlan(), $cart->item->getCategory());

            $currentPrice = geoNumber::format($myPlanItem->get('price',0.00));
            
            //129-135 in addon_attention getter, inside if statement
            
            $order_item = new pp4classifiedOrderItem;
            $order_item->setParent($cart->item);//this is a child of the parent
            $order_item->setOrder($cart->order);
            //test manually setting the category so it adds a different price -Brent
            $order_item->setCost($currentPrice);
            $already_attached = false;
            $order_item->save();//make sure it's serialized
            $cart->order->addItem($order_item);
            

            //get the price for attention_getter
            //$cost =  $cart->item->getCategory().'.34';
            //($cart->db->get_site_setting('all_ads_are_free'))? 0:$cart->price_plan['attention_getter_price'];
            //$order_item->setCost($cost);
            $order_item->setCreated($cart->order->getCreated());        
            $order_Id = $cart->order->getId();
            $ppEmail = $_POST['c']['pp4classifiedemail'];
            $ppCount = $_POST['c']['pp4classifiedcount'];
            $insert = "INSERT INTO `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders` 
            (`order_id`, `item_count`, `paypal_address`) 
            VALUES ($order_Id, $ppCount, '$ppEmail')";
            $db->Execute($insert);
        }        
        
        
        
    }      
    
        
    
    
    
    
    /**
     * Optional.
     * Used: from geoCart::setPricePlan()
     * 
     * Most should remove this function.  Its use would be to set some price plan setting
     * in addition to the settings auto retrieved.  An example of where it is used is in
     * the subscription order item.
     *
     * @param array $vars array ('price_plan' => int, 'category' => int)
     */
     /*
    public static function geoCart_setPricePlan ($vars)
    {
        //TODO: Remove or implement...
        echo "<pre>qwerty</pre>";
        
    }    
    */
    
    
    public function geoCart_other_detailsLabel()
    {
      return "Paypal Button for Classifieds details";   
    }
    
    
     
    public function processStatusChange ($newStatus, $sendEmailNotices = true, $updateCategoryCount = false)
    {
        $test = 1;
        if ($newStatus == $this->getStatus())
        {
            if ($this->parent->getType() != "listing_renew_upgrade")
            //the status hasn't actually changed, so nothing to do
            {
                 return;
            }
            
        }
        $activate = ($newStatus == 'active')? true: false;
        
        $already_active = ($this->getStatus() == 'active')? true: false; 
        
        //allow parent to do common things, like set the status and
        //call children items
        parent::processStatusChange($newStatus, $sendEmailNotices, $updateCategoryCount);
        
        $parent = $this->getParent();
        if (!$parent) 
        {
            //Doh!  this should not happen.
            trigger_error('ERROR CART: Count not get parent, this should not happen!');
            return;
        }
        //$util = geoAddon::getUtil(self::addonName);
        $db = 1;
        require GEO_BASE_DIR . 'get_common_vars.php';
        if ($parent->getType() == 'listing_edit') 
        {
                $order = $this->parent->getOrder();
                $oder_id = $order->getId();


                $pp_array = array_pop($this->parent->get('pp_array'));
                $test = 1;

                $insert = "INSERT INTO `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders` 
                (`item_count`, `paypal_address`, `listing_id`) 
                VALUES ('$pp_array[count]', '$pp_array[email]', '".$this->parent->get(listing_id)."')
                ON DUPLICATE KEY UPDATE `item_count` = '$pp_array[count]', `paypal_address` =  '$pp_array[email]'";
                $result = $db->Execute($insert);           

        } 
        if ($parent->getType() == 'listing_renew_upgrade') 
        {
                $order = $this->parent->getOrder();
                $oder_id = $order->getId();


                $pp_array = array_pop($this->parent->get('pp_array'));
                $test = 1;

                $insert = "INSERT INTO `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders` 
                (`item_count`, `paypal_address`, `listing_id`) 
                VALUES ('$pp_array[count]', '$pp_array[email]', '".$this->parent->get(listing_id)."')
                ON DUPLICATE KEY UPDATE `item_count` = '$pp_array[count]', `paypal_address` =  '$pp_array[email]'";
                $result = $db->Execute($insert);           

        }         
        if ($parent->getType() == 'classified') 
 
        {
            //either totally add them or totally remove them since we are activating
            //or deactivating a listing
            if ($activate) 
            {
                $order = $this->parent->getOrder();
                $oder_id = $order->getId();


                $pp_array = array_pop($this->parent->get('pp_array'));
                $test = 1;

                $insert = "INSERT INTO `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders` 
                ( `item_count`, `paypal_address`, `listing_id`) 
                VALUES ( '$pp_array[count]', '$pp_array[email]', '".$this->parent->get(listing_id)."')
                ON DUPLICATE KEY UPDATE `item_count` = '$pp_array[count]', `paypal_address` =  '$pp_array[email]'";
                $result = $db->Execute($insert);                

                
                
            } 
            

        }
        //NOTE: do not need to call children, parent does that for us :)
    }

      

    /**
     * Optional.
     * Used: In admin, when displaying the order item type for a particular item, used
     * in various places in the admin.
     * 
     * @return string
     */
    public function getTypeTitle ()
    {
        //TODO: implement or remove...
        //this is what it uses by default if the method getTypeTitle() does not exist.
        return "GeoModules Paypal for Classifieds";
    }

     /**
     * Optional.
     * Used: In admin, when displaying an order item's details
     * 
     * Return HTML for displaying or editing any information about this item, to 
     * be displayed in the admin.  Should also call any children of this item.
     * 
     * The other function that should work with this one, is adminItemUpdate.
     *
     * @param int $item_id
     * @return string
     */
     
    public static function adminItemDisplay ($item_id)
    {
        //TODO: Implement or remove
        
        $html = 'Details for item #'.$item_id;
        
        //Call children and let them display info about themselves as well
        $children = geoOrderItem::getChildrenTypes(self::type);
        $html .= geoOrderItem::callDisplay('adminItemDisplay',$item_id,'',$children);
        
        return $html;
    }
    






     /**
     * Optional, but required if displayInAdmin() returns true.
     * Used: in admin, display items awaiting approval (only for main items, not for sub-items)
     *
     * @return array Associative array, in the form array ('type' => string, 'title' => string)
     */
    public function adminDetails ()
    {
        //TODO: implement or remove if displayInAdmin returns false...
        $session_variables = $this->get('session_variables');
        $title = $session_variables['classifieds_title'];
        if (strlen($title) > 20) {
            $title = substr($title,0,17).'...';
        }
        $title = $this->getId() . ' - '.$title;
        // displayed in admin orders
        return array(
            'type' => 'Other Details Option ',
            'title' => 'Paypal button for classifieds'
        );
    }





    
    //required by system
    public function displayInAdmin() 
    {
        return true;
    }
 
    //required by system, doesn't have to do anything though
    public static function geoCart_initSteps($allPossible=false)
    {
 
    }
 
    //required by system
    public static function geoCart_initItem_forceOutsideCart() 
    {
        return false;
    }
 
    //required by system
    public static function getParentTypes()
    {
        return array('classified','listing_edit','listing_renew_upgrade');
    }
 
    /**
     * Required.
     * Used: Throughout the software, wherever order details are displayed.
     * 
     * Used to get display details about item, and any child items as well, both in the main
     * cart view, and other places where the order details are displayed, including within
     * the admin.  Should return an associative array, that follows:
     * array(
     *     'css_class' => string, //leave empty string for default class, only applies in cart view
     *     'title' => string,
     *     'canEdit' => bool, //whether can edit it or not, only applies in cart view
     *     'canDelete' => bool, //whether can remove from cart or not, only applies in cart view
     *     'canPreview' => bool, //whether can preview the item or not, only applies in cart view
     *     'priceDisplay' => string, //price to display
     *     'cost' => double, //amount this adds to the total, what getCost returns but positive
     *     'total' => double, //amount this AND all children adds to the total
     *     'children' => array(), //optional, should be array of child items, with the index
     *                             //being the item's ID, and the contents being associative array like
     *                             //this one.  Careful not to get into any infinite loops...
     * )
     * 
     * @param bool $inCart True if this is being called from inside the cart, false otherwise. Note: do NOT
     *  try to use the geoCart object if $inCart is false.
     * @return array|bool Either an associative array as documented above, or boolean false to hide this
     *  item from view.
     */
    public function getDisplayDetails ($inCart)
    {
        $textArray = geoAddon::getText('geo_modules', 'GeoModules_Paypal4Classifieds', $db->getLanguage);
        $pp4classified_label = $textArray['pp4classified_label'];
        //TODO: implement...
        
        //NOTE: This function is sometimes called "outside" of the cart environment (when $inCart is
        //false), so it is best to not rely on geoCart object for anything.\        
        $db = 1;
        require GEO_BASE_DIR . 'get_common_vars.php';
        
        
    
     
    
        
        
        
        
        if (($inCart != 'true'))
        {
            //$cart = geoCart::getInstance();
            //echo "<br/> results of incart ". $inCart;
            //echo "results";
            //do checking of vars here
            //$myPlanItem = geoPlanItem::getPlanItem('pp4classified',$cart->item->getPricePlan(),$cart->item->getCategory());
            //$currentPrice = geoNumber::format($myPlanItem->get('price',0.00)); 
            
         
            
            $return = array 
            (
            
            'css_class' => '',//empty string to use default CSS class in the HTML, otherwise a string containing the css class name.
            'title' => $pp4classified_label,//text that is displayed for this item in list of items purchased.
            'canEdit' => true, //show edit button for item, if displaying in cart?
            'canDelete' => true, //show delete button for item, if displaying in cart?
            'canPreview' => true, //show preview button for item, if displaying in cart?
            'priceDisplay' => $db->get_site_setting('precurrency').geoNumber::format($this->getCost()).$db->get_site_setting('postcurrency'), //Price as it is displayed
            'cost' => $this->getCost(), //amount this adds to the total, what getCost returns
            'total' => $this->getCost(), //amount this AND all children adds to the total (will add to it as we parse the children)
            'children' => array()     //should be array of child items, with the index
                                     //being the item's ID, and the contents being associative array like
                                     //this one.  If no children, it should be an empty array.  (Careful 
                                    //not to get into any infinite recursion)
            );
        }
        
        
        if (($inCart == 'true'))
        {
            
        $cart = geoCart::getInstance(); //get instance of cart
        $order_Id = $cart->order->getId();  
        $get = "SELECT * FROM `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders` 
        WHERE `order_id` = $order_Id";
        $ppRow = $db->GetRow($get);   
            
            $return = array (
            'css_class' => '',//empty string to use default CSS class in the HTML, otherwise a string containing the css class name.
            'title' => $pp4classified_label. ' ('.$ppRow['item_count']. ' '. $textArray['pp4classified_multi_item_label'].') '. $textArray['pp4classified_email_address_label'].': '.   $ppRow['paypal_address'],//text that is displayed for this item in list of items purchased.
            'canEdit' => false, //show edit button for item, if displaying in cart?
            'canDelete' => true, //show delete button for item, if displaying in cart?
            'canPreview' => false, //show preview button for item, if displaying in cart?
            'priceDisplay' => $db->get_site_setting('precurrency').geoNumber::format($this->getCost()).$db->get_site_setting('postcurrency'), //Price as it is displayed
            'cost' => $this->getCost(), //amount this adds to the total, what getCost returns
            'total' => $this->getCost(), //amount this AND all children adds to the total (will add to it as we parse the children)
            'children' => array()     //should be array of child items, with the index
                                     //being the item's ID, and the contents being associative array like
                                     //this one.  If no children, it should be an empty array.  (Careful 
                                    //not to get into any infinite recursion)
            );   
            
            
        }

        
        
        
        

        
        //THIS PART IMPORTANT:  Need to keep this part to make the item is able to have children.
        //You don't want your item to be sterile do you?
        
        //go through children...
        $order = $this->getOrder();//get the order
        $items = $order->getItem();//get all the items in the order
        $children = array();
        foreach ($items as $i => $item){
            if (is_object($item) && $item->getType() != $this->getType() && is_object($item->getParent())){
                $p = $item->getParent();//get parent
                if ($p->getId() == $this->getId()){
                    //Parent is same as me, so this is a child of mine, add it to the array of children.
                    //remember the function is not static, so cannot use callDisplay() or callUpdate(), need to call
                    //the method directly.
                    $displayResult = $item->getDisplayDetails($inCart);
                    if ($displayResult !== false) {
                        //only add if they do not return bool false
                        $children[$item->getId()] = $displayResult;
                        $return['total'] += $children[$item->getId()]['total']; //add to total we are returning.
                    }
                    
                }
            }
        }
        if (count($children)){
            //add children to the array
            $return['children'] = $children;
        }
        return $return;
    }
 
    //required by system
    public static function geoCart_initSteps_addOtherDetails(){
        return false;
    }
    
    public static function getMyPlanItem($pricePlanID, $categoryID)
    {
        $db = 1;
        require GEO_BASE_DIR . 'get_common_vars.php';
        //$myPlanItem = geoPlanItem::getPlanItem('pp4classified',$cart->item->getPricePlan(),$cart->item->getCategory(), true);
        
        $sql = "SELECT * FROM `geodesic_plan_item_registry` WHERE `plan_item` = 'pp4classified:$pricePlanID:$categoryID'" ;
        $result = $db->GetRow($sql);
        
        if (count($result)== 0)
        {
            $myPlanItem = geoPlanItem::getPlanItem('pp4classified',$pricePlanID,$categoryID);
        }
        else
        {
            $myPlanItem = geoPlanItem::getPlanItem('pp4classified',$pricePlanID,$categoryID, true);
        }
        
        return $myPlanItem; 
        
        
        
    }
    
        /**
     * Optional.
     * Used: from geoOrderItem::remove() when removing an order item.
     * 
     * Use this function if you need to do things like remove a listing from the database, or delete
     * images or something.  Be sure to return true or the item will not be removed by the system.
     * 
     * Note that normal back-end stuff like removing registry settings and removing the order item
     * from the DB are handled by the system, this function is primarily for special case stuff like
     * deleting files, or removing stuff from the DB that isn't part of normal order items.
     * 
     * @return bool True to proceed with removing the item, false to stop the removal of the item.
     */
    public function processRemove ()
    {
        //TODO: Implement or remove...  
        /*
        //should not need to remove from db anymore since I am now only adding to db when order status changes to active
        $db = 1;
        require GEO_BASE_DIR . 'get_common_vars.php';
        $parent_order_item = geoOrderItem::getOrderItem($this->parent);
        $parent_order = geoOrder::getOrder($this->order);
        $listing_id = $this->parent->get('listing_id');
        $cart = geoCart::getInstance(); //get instance of cart
        $order_Id = $cart->order->getId();  
        $remove = "DELETE FROM `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders` 
        WHERE `listing_id` = $listing_id";
        $db->Execute($remove);
        */
        return true;
    }
    
    
    
    
    
    
    
        /**
     * Optional.
     * Used: In listing_editOrderItem::geoCart_initSteps()
     * 
     * NOT part of built-in cart system.
     * 
     * Special case, functionality built into individual order items.
     * 
     * This can be used to add additional things to be edited when editing
     * a listing.
     * @return array Associative array, as documented in function.
     */
     
    public static function listing_edit_getChoices ($vars)
    {
        //TODO: Implement or remove
        
        $cart = geoCart::getInstance();
        $test = 1;
        //If we wanted to edit something specific to this item type,
        //we can do so (below requires appropriate functions added
        //that would be needed for a step named "our_edit_step"):
        
        if ($cart->site->session_variables['blarg'])
        {
            //already exists on parent, do not allow adding
            return array ('pp4classified:edit' => 'blarg');
        }          

        if ($cart->site->session_variables['pp4classified'])
        {
            //already exists on parent, do not allow adding
            return array ('pp4classified:edit' => 'Edit Paypal Information');
        }
        
 
        
    }
    
    //public static function editLabel ()
    //{
        
    //    return "qwerty5";
    //}
    public static function editDisplay ()
    {
        // what if I just do something else here?
        $cart = geoCart::getInstance();
        //echo $cart->order->getId();
        /*
        $listing = geoListing::getListing($cart->item->get('listing_id'));
        $db = 1;
        require GEO_BASE_DIR . 'get_common_vars.php';
        $SQLorignalOrder = 'SELECT  `order_item`
                FROM 
                `geodesic_order_item_registry`
                WHERE `index_key` = "listing_id"
                AND
                `val_string` = "'.$cart->item->get('listing_id') .'"
                LIMIT 1';
        $originalOrderIdResult = $db->GetArray($SQLorignalOrder);
        $originalOrderId = $originalOrderIdResult[0][order_item];
        
        $SQLorignalOrderItem = 'SELECT `order` FROM `geodesic_order_item` 
                                WHERE `parent` = "'.$originalOrderId.'"
                                AND
                                `type` = "pp4classified"';
        $originalOrderItemId = $db->GetOne($SQLorignalOrderItem);
        
        
        
        $sqlIsThere = "SELECT * FROM `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders`
                        WHERE `order_id` = \"".$originalOrderItemId."\"";
        
        $isThere = $db->GetArray($sqlIsThere);
        
        //$listing = geoListing::getListing($cart->item->get('listing_id'));
        echo "The original order ID: ".$originalOrderId."<br/>";
        echo "The original order item ID: ".$originalOrderItemId."<br/>";
        echo "sql statement for original order item <br/>".$sqlIsThere."<br/>";
        echo "ddddddddddddddd <br/>parent session<br/><pre>".print_r($isThere, true)."</pre><br/>";
        if (count($isThere))
        {
        
            echo "It's there" .$cart->item->getType();
            listing_editOrderItem::fixStepLabels();
            $cart->displaySingleOtherDetails(self::type);
        
        }
        
        else
        {
            echo "No order found" ;
        }
         */
        listing_editOrderItem::fixStepLabels();
        $cart->displaySingleOtherDetails(self::type);
        

    }
    
    public static function editProcess ()
    {
        // not run in normal cart add item does not contribute to double orderItem addition
        // calling a non-existant method does not produce error in fresh order.
        //self::geoCart_other_detailsProdsafces();
        $cart = geoCart::getInstance();
        //$echo = "hi </br>";
        //$echo .= print_r($cart->item, true)  ;
        
        $db = 1;
        require GEO_BASE_DIR . 'get_common_vars.php';
        //might refactor this part later
        $listingId = $cart->item->get(listing_id); // the listing ID
        /*
        $sqlGetOrderItemId = "SELECT `order_item_id` FROM `geodesic_classifieds`
        WHERE `id` = $listingId";
        $orderItemId = $db->GetOne($sqlGetOrderItemId);// this needs to be checked once a order in renewed/upgraded/edited ie will orderItemId change
        $sqlGetParentOrderId = "SELECT `order` FROM `geodesic_order_item`
        WHERE `id` = $orderItemId";
        $order_Id = $db->GetOne($sqlGetParentOrderId);
        */
        
        //$order_Id = $cart->order->getId();
        $ppEmail = $_POST['c']['pp4classifiedemail'];
        $ppCount = $_POST['c']['pp4classifiedcount'];
        $insert = "INSERT INTO `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders` 
        (`listing_id`, `item_count`, `paypal_address`) 
        VALUES ($listingId, $ppCount, '$ppEmail')
        ON DUPLICATE KEY UPDATE
        `item_count` =  '$ppCount', `paypal_address` =  '$ppEmail'
        ";
        //$echo .= "the order id is $order_Id and the listing id is $listingId</br>";
        
        /*$insert = "UPDATE `geodesic_addon_GeoModules_Paypal4Classifieds_site_orders`
        SET `item_count` =  '$ppCount', `paypal_address` =  '$ppEmail'
        WHERE `listing_id` =  '$listingId'"; */
        
        $result = $db->Execute($insert);
        //echo $result;
    }
    
    public static function editCheckVars ()
    {
        
        if ($_POST['c']['pp4classifiedemail'])
        {
            $cart = geoCart::getInstance();
            //do checking of vars here

            // brent's bool to determine adding to the cart
            $addStatus = true;
            
            $ppEmail = $_POST['c']['pp4classifiedemail'];
            if ($cart->main_type != self::type && !in_array($cart->main_type, geoOrderItem::getParentTypesFor(self::type)))
            {
                //item being added does not have anything to do with this item, so no need to check vars.
                $addStatus = false;
                return;
            }
            if ($check)
            {
                //dummy check, to demonstrate how to tell the cart there is a problem and to not proceed to next step yet.
                $cart->addError();
            }
            
            if (!geoString::isEmail($ppEmail) )
            {
                $addStatus = false;
                $cart->addError();
                $cart->addErrorMsg('ppEmailInvalid', 'Your Paypal emial address does not appear to be a valid email address.');
            }
            
            if ( !(preg_match( '/^\d*$/'  , $_POST['c']['pp4classifiedcount']) == 1) )
            {
                $addStatus = false;
                $cart->addError();
                $cart->addErrorMsg('ppCountInvalid', 'The entry for the number of items you are listing via the PayPal payment feature needs to be a valid and/or whole number.');                
            }
            if ($_POST['c']['pp4classifiedcount'] < '1') 
            {
                $addStatus = false;
                $cart->addError();
                $cart->addErrorMsg('ppCountInvalid', 'The entry for the number of items you are listing via the PayPal payment feature needs to be greater than zero..');                
            } 
        }
        /*
        // now that all the error checking has been done
        if ($addStatus)
        {
            pp4classifiedOrderItem::brentsRealProcess();
        }
        */         


        // not run in normal cart add item does not contribute to double orderItem addition
        //$cart = geoCart::getInstance();
        //$cart->addError();
        //$cart->addErrorMsg('ppEmailInvalid', 'Your Paypal sdaf email address.');
        
    }
    
    
    
    
    /**
     * Required.
     * Used: By payment gateways to see what types of items are in the cart.
     * 
     * Note that for backwards compatibility with older order items, this is implemented
     * in the parent geoOrderItem class, so if you leave it off it will "work".
     * It is still highly recommended to implement anyways in each order item, 
     * simply because it's role will be much more important when the ability to
     * use the cart between users is implemented down the road.
     * 
     * This is very similar to {@see _templateOrderItem::getDisplayDetails()} except that the
     * information is used by payment gateways and is specifically for information about what
     * the "cost" of something is for.
     * 
     * Should return an associative array, that follows:
     * array(
     *     'type' => string, //The order item type, should always be $this->getType()
     *     'extra' => mixed, //used to convey to payment gateways "custom information" that
     *                         may be needed by the gateway.  Most can set this to null.
     *  'cost' => double, //amount this adds to the total, what getCost returns
     *     'total' => double, //amount this AND all children adds to the total
     *     'children' => array(), //optional, should be array of child items, with the index
     *                             //being the item's ID, and the contents being associative array like
     *                             //this one.  Careful not to get into any infinite loops...
     * )
     * 
     * @return array|bool Either an associative array as documented above, or boolean false if
     *   this item has no cost (positive or negative, including children).
     * @since Version 6.0.0
     */
    public function getCostDetails ()
    {
        //Most use this exactly AS-IS...
    
        $return = array (
                'type' => $this->getType(),
                'extra' => null,
                'cost' => $this->getCost(),
                'total' => $this->getCost(),
                'children' => array(),
        );
        
        //call the children and populate 'children'
        $order = $this->getOrder();//get the order
        $items = $order->getItem();//get all the items in the order
        $children = array();
        foreach ($items as $i => $item) {
            if (is_object($item) && $item->getType() != $this->getType() && is_object($item->getParent())) {
                $p = $item->getParent();//get parent
                if ($p->getId() == $this->getId()){
                    //Parent is same as me, so this is a child of mine, add it to the array of children.
                    //remember the function is not static, so cannot use callDisplay() or callUpdate(), need to call
                    //the method directly.
                    $costResult = $item->getCostDetails();
                    if ($costResult !== false) {
                        //only add if they do not return bool false
                        $children[$item->getId()] = $costResult;
                        $return['total'] += $costResult['total']; //add to total we are returning.
                    }
    
                }
            }
        }
        if ($return['total']<>0) {
            //total is 0, even after going through children!  no cost details to return
            return false;
        }
        if (count($children)) {
            //add children to the array
            $return['children'] = $children;
        }
        return $return;
    }    
    
    
    
       
    
}
